/*
 * Decompiled with CFR 0.152.
 */
package formdef.plugin.config;

import formdef.plugin.FormMapping;
import formdef.plugin.PropertyMapping;
import formdef.plugin.config.FormDefConfig;
import formdef.plugin.config.GlobalConverterConfig;
import formdef.plugin.config.PropertyMappingConfig;
import formdef.plugin.conversion.Converter;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormMappingConfig {
    private static final Log log = LogFactory.getLog((Class)(class$formdef$plugin$config$FormMappingConfig == null ? (class$formdef$plugin$config$FormMappingConfig = FormMappingConfig.class$("formdef.plugin.config.FormMappingConfig")) : class$formdef$plugin$config$FormMappingConfig));
    protected String name;
    protected String beanType;
    protected String formType;
    protected String factory;
    protected String factoryMethodName;
    protected String factoryMethodNameParam = "false";
    protected List properties = new ArrayList();
    protected String excludes;
    protected List excludedProperties;
    static /* synthetic */ Class class$formdef$plugin$config$FormMappingConfig;
    static /* synthetic */ Class class$java$lang$String;

    public FormMappingConfig() {
    }

    public FormMappingConfig(String name, String beanType) {
        this();
        this.name = name;
        this.beanType = beanType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public void setBeanType(String beanType) {
        this.beanType = beanType;
        if (beanType != null && beanType.length() <= 0) {
            this.beanType = null;
        }
    }

    public String getFormType() {
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getFactoryMethodName() {
        return this.factoryMethodName;
    }

    public void setFactoryMethodName(String factoryMethodName) {
        this.factoryMethodName = factoryMethodName;
    }

    public String getFactoryMethodNameParam() {
        return this.factoryMethodNameParam;
    }

    public void setFactoryMethodNameParam(String factoryMethodNameParam) {
        this.factoryMethodNameParam = factoryMethodNameParam;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public void addProperty(PropertyMappingConfig propertyConfig) {
        this.properties.add(propertyConfig);
    }

    public PropertyMappingConfig getProperty(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        int i = 0;
        while (i < this.properties.size()) {
            PropertyMappingConfig config = (PropertyMappingConfig)this.properties.get(i);
            if (config != null && propertyName.equals(config.getName())) {
                return config;
            }
            ++i;
        }
        return null;
    }

    public FormMapping generateForm(FormDefConfig formDefConfig) throws Exception {
        FormMapping form = null;
        Class<?> associatedType = null;
        if (this.getBeanType() != null) {
            associatedType = Class.forName(this.getBeanType());
            form = new FormMapping(this.getName(), associatedType);
            if (this.factory != null && this.factoryMethodName != null) {
                this.initializeFactory(form);
            }
            this.resolveProperties(associatedType);
        } else {
            form = new FormMapping(this.getName(), null);
        }
        Map formProperties = form.getProperties();
        int i = 0;
        while (i < this.properties.size()) {
            PropertyMappingConfig config = (PropertyMappingConfig)this.properties.get(i);
            if (this.isExcluded(config)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Excluding property: " + config.getName()));
                }
            } else {
                PropertyMapping property = config.generateProperty(form, formDefConfig);
                this.applyGlobalConverters(property, config, formDefConfig);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Created property: " + property));
                }
                formProperties.put(config.getName(), property);
            }
            ++i;
        }
        return form;
    }

    private boolean isExcluded(PropertyMappingConfig config) {
        if (config == null) {
            return false;
        }
        if (config.getExclude() != null && Boolean.valueOf(config.getExclude()).booleanValue()) {
            return true;
        }
        String propertyName = config.getName();
        return this.getExcludedProperties().contains(propertyName);
    }

    protected List getExcludedProperties() {
        if (this.excludedProperties != null) {
            return this.excludedProperties;
        }
        this.excludedProperties = new ArrayList();
        if (this.excludes == null) {
            return this.excludedProperties;
        }
        StringTokenizer st = new StringTokenizer(this.excludes, ", \t\n\r\f");
        while (st.hasMoreTokens()) {
            this.excludedProperties.add(st.nextToken());
        }
        return this.excludedProperties;
    }

    protected void initializeFactory(FormMapping form) throws Exception {
        Class<?> factoryType = Class.forName(this.factory);
        Constructor<?> constructor = factoryType.getConstructor(new Class[0]);
        Object factory = constructor.newInstance(new Object[0]);
        Method factoryMethod = null;
        boolean useMethodNameParameter = "true".equals(this.factoryMethodNameParam);
        factoryMethod = useMethodNameParameter ? factoryType.getMethod(this.factoryMethodName, class$java$lang$String == null ? (class$java$lang$String = FormMappingConfig.class$("java.lang.String")) : class$java$lang$String) : factoryType.getMethod(this.factoryMethodName, new Class[0]);
        form.setFactoryMethod(factory, factoryMethod, useMethodNameParameter);
    }

    private void applyGlobalConverters(PropertyMapping property, PropertyMappingConfig config, FormDefConfig formDefConfig) {
        GlobalConverterConfig converterConfig;
        String name = config.getConverterName();
        if (name != null && name.length() > 0 && (converterConfig = formDefConfig.findConverterNameConverter(name)) != null) {
            this.applyConverterConfiguration(property, converterConfig);
            return;
        }
        converterConfig = formDefConfig.findPropertyNameConverter(property.getName());
        if (converterConfig != null) {
            this.applyConverterConfiguration(property, converterConfig);
            return;
        }
        converterConfig = formDefConfig.findPropertyTypeConverter(property.getType());
        log.trace((Object)("converterConfig=" + converterConfig));
        if (converterConfig != null) {
            log.trace((Object)("applying to " + property));
            this.applyConverterConfiguration(property, converterConfig);
            log.trace((Object)("property=" + property));
            return;
        }
    }

    private void applyConverterConfiguration(PropertyMapping property, GlobalConverterConfig converterConfig) {
        Converter converter = (Converter)property.getConverter();
        String param = property.getConversionParam();
        String paramKey = property.getConversionKey();
        String paramBundle = property.getConversionBundle();
        if (converterConfig.getTypeName() != null) {
            converter = (Converter)converterConfig.getConverter();
        }
        if (converterConfig.getConversionParameter() != null) {
            if (param == null) {
                param = converterConfig.getConversionParameter();
            } else if (log.isTraceEnabled()) {
                log.trace((Object)(property.getName() + " converter: " + " A conversion parameter was specified for this;" + " this will take precedence over" + " the global setting."));
            }
        }
        if (converterConfig.getConversionKey() != null) {
            if (paramKey == null) {
                paramKey = converterConfig.getConversionKey();
                paramBundle = converterConfig.getConversionBundle();
            } else if (log.isTraceEnabled()) {
                log.trace((Object)(property.getName() + " converter: " + " A conversion parameter was specified for this;" + " this will take precedence over" + " the global setting."));
            }
        }
        if (param != null) {
            property.setConverter(converter, param);
        } else {
            property.setConverter(converter, paramKey, paramBundle);
        }
    }

    protected void resolveProperties(Class associatedType) {
        Method setter;
        PropertyDescriptor descriptor;
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors((Class)associatedType);
        int i = 0;
        while (i < this.properties.size()) {
            PropertyMappingConfig config = (PropertyMappingConfig)this.properties.get(i);
            descriptor = null;
            int j = 0;
            while (j < descriptors.length) {
                PropertyDescriptor temp = descriptors[j];
                if (temp.getName().equals(config.getName())) {
                    descriptor = temp;
                    break;
                }
                ++j;
            }
            if (config.getGetter() == null && descriptor != null) {
                Method getter = PropertyUtils.getReadMethod((PropertyDescriptor)descriptor);
                config.setGetter(getter.getName());
            }
            if (config.getSetter() == null && descriptor != null) {
                setter = PropertyUtils.getWriteMethod((PropertyDescriptor)descriptor);
                config.setSetter(setter.getName());
            }
            ++i;
        }
        int j = 0;
        while (j < descriptors.length) {
            descriptor = descriptors[j];
            if (!this.getExcludedProperties().contains(descriptor.getName())) {
                Method getter = PropertyUtils.getReadMethod((PropertyDescriptor)descriptor);
                setter = PropertyUtils.getWriteMethod((PropertyDescriptor)descriptor);
                if (getter != null && setter != null) {
                    PropertyMappingConfig config;
                    boolean isOnTheList = false;
                    int i2 = 0;
                    while (i2 < this.properties.size()) {
                        config = (PropertyMappingConfig)this.properties.get(i2);
                        if (descriptor.getName().equals(config.getName())) {
                            isOnTheList = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!isOnTheList) {
                        config = new PropertyMappingConfig();
                        config.setName(descriptor.getName());
                        config.setSetter(setter.getName());
                        config.setGetter(getter.getName());
                        this.properties.add(config);
                    }
                }
            }
            ++j;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("FormMappingConfig [");
        result.append("name=").append(this.getName()).append(";");
        if (this.beanType != null) {
            result.append("beanType=").append(this.beanType).append(";");
        }
        if (this.formType != null) {
            result.append("formType=").append(this.formType).append(";");
        }
        if (this.factory != null) {
            result.append("factory=").append(this.factory).append(";");
        }
        if (this.factoryMethodName != null) {
            result.append("factoryMethodName=").append(this.factoryMethodName).append(";");
        }
        if (this.factoryMethodNameParam != null) {
            result.append("factoryMethodNameParam=").append(this.getFactoryMethodNameParam()).append(";");
        }
        if (this.excludes != null) {
            result.append("excludes=").append(this.excludes).append(";");
        }
        int i = 0;
        while (i < this.properties.size()) {
            PropertyMappingConfig config = (PropertyMappingConfig)this.properties.get(i);
            result.append("\n").append(config);
            ++i;
        }
        result.append("\n]");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

