/*
 * Decompiled with CFR 0.152.
 */
package formdef.plugin.util;

import formdef.plugin.util.PropertyResourceLocaleUtil;
import formdef.plugin.util.ResourceLocaleUtil;
import formdef.plugin.util.ResourceLocaleUtilFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;

public class ResourceLocaleUtilFactoryImpl
implements ResourceLocaleUtilFactory {
    protected static Map rlufMap = Collections.synchronizedMap(new HashMap());

    public ResourceLocaleUtil getLocaleUtil(HttpServletRequest request, ServletContext servletContext, String bundle) {
        String key = this.getCacheKey(request, servletContext, bundle);
        Object result = rlufMap.get(key);
        if (result == null) {
            result = this.createResourceLocaleUtil(key, request, servletContext, bundle);
            rlufMap.put(key, result);
        }
        return (ResourceLocaleUtil)result;
    }

    protected ResourceLocaleUtil createResourceLocaleUtil(String key, HttpServletRequest request, ServletContext servletContext, String bundle) {
        if (bundle == null) {
            bundle = "";
        }
        MessageResources resources = null;
        resources = "".equals(bundle) ? this.getResources(request) : this.getResources(bundle, request, servletContext);
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request, servletContext);
        PropertyResourceLocaleUtil result = new PropertyResourceLocaleUtil(servletContext, moduleConfig, resources.getConfig());
        return result;
    }

    protected String getCacheKey(HttpServletRequest request, ServletContext servletContext, String bundle) {
        if (bundle == null) {
            bundle = "";
        }
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request);
        String moduleName = moduleConfig.getPrefix();
        String key = moduleName + "_" + bundle;
        return key;
    }

    protected MessageResources getResources(HttpServletRequest request) {
        return (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
    }

    protected MessageResources getResources(String bundle, HttpServletRequest request, ServletContext servletContext) {
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request, servletContext);
        return (MessageResources)servletContext.getAttribute(bundle + moduleConfig.getPrefix());
    }
}

