<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:import href="menu.xsl"/>    
<xsl:template match="document">
    <html>
    <head>
    <STYLE>
    body {
        font-family: verdana;
        font-size: 10pt;
    }
    table {
        font-family: verdana;
        font-size: 10pt;
    }
    .chapter {
        font-weight: bold;
        background-color: black;
        color: white;
        font-size: 12pt;
    }
    .section {
        font-weight: bold;
        background-color: navy;
        color: white;
    }
    .content {
    }
    a {
        color: blue;
    }
    </STYLE>
    <title><xsl:value-of select="@title"/></title>
    </head>
    <body>
    <table border="0" cellspacing="0" align="left" width="100%">
    <tr valign="top">
        <td>
        <xsl:call-template name="menu"/>
        </td>
        <td>
        <h2><xsl:value-of select="@title"/></h2>
        <br/>
        <xsl:choose>
            <xsl:when test="count(chapter) &gt; 1">
                <xsl:call-template name="chapterlist"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- do a for-each to move the current node one level down-->
                <xsl:for-each select="chapter">
                    <xsl:call-template name="sectionlist"/>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="chapter"/>
        </td>
    </tr>
    </table>
    </body>
    </html>
</xsl:template>
    
<xsl:template name="chapterlist">
    <xsl:for-each select="chapter">
        <b><xsl:value-of select="@title"/></b>
        <p/>
        <xsl:call-template name="sectionlist"/>
        <p/><br/>
    </xsl:for-each>
</xsl:template>
    
<xsl:template name="sectionlist">
    <!-- Create a list of all the available items' titles with a link to their content -->
    <ul>
    <xsl:for-each select="section">
        <!--<xsl:number value="position()" format="1" />.-->
        <li><a href="#{@href}"><xsl:value-of select="title"/></a></li>
        <br/>
    </xsl:for-each>
    </ul>
</xsl:template>    

<xsl:template match="chapter">

    <p/><br/><p/>
    <xsl:if test="count(../chapter) &gt; 1">
        <a name="{./@href}"/>
        <div class="chapter">
        <xsl:text>&#160;&#160;</xsl:text><xsl:value-of select="@title"/>
        </div>
        <p/>        
    </xsl:if>

    <xsl:for-each select="section">
        <div class="section">
            &#160;
            <a name="{./@href}"/>
            <!--<xsl:number value="position()" format="1" />.-->
            <xsl:text> </xsl:text>
            <xsl:value-of select="title"/>
        </div>
        <div class="content">
            <br/>
            &#160;&#160;&#160;
            <xsl:copy-of select="content"/>
        </div>
        <p/><br/>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>