package formdef.plugin.example.locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.*;

/**
 * Action to change the locale used for the current user.
 */
public class ChangeLocaleAction extends Action {

    /**
     * Calls {@link Action}'s setLocale() method to change the locale
     * for the current user.
     */
    public ActionForward execute(ActionMapping mapping,
                                 ActionForm form,
                                 HttpServletRequest request,
                                 HttpServletResponse response)
            throws Exception {

        // cast the form to DynaActionForm
        DynaActionForm changeLocaleForm = (DynaActionForm) form;

        // get the locale requested by the user
        java.util.Locale newLocale =
                new java.util.Locale((String)changeLocaleForm.get("locale"));

        // set the locale as requested
        setLocale(request, newLocale);

        return mapping.findForward("showForm");
    }

}
