package formdef.plugin.example.locale;

import formdef.plugin.util.FormUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;

/**
 * Processes employee data submitted by the user.
 */
public class LocaleAction extends Action {

    private static final Log log = LogFactory.getLog(LocaleAction.class);

    /**
     * Read the data from the submitted form into an employee object.
     */
    public ActionForward execute(ActionMapping mapping,
                                 ActionForm form,
                                 HttpServletRequest request,
                                 HttpServletResponse response)
            throws Exception {

        Employee employee = null;

        if (form != null) {
            if (log.isDebugEnabled()) {
                // log a statement to show the contents of the form as received
                log.debug("received form=" + form);
            }

            // call getFormValues() to get our employee object
            employee = (Employee) FormUtils.getFormValues(form,
                    this, mapping, request);

            // save this employee as a session object
            request.getSession().setAttribute("employee", employee);

            // now display the parsed employee information
            log.info("received employee=" + employee);
        }

        // check if there's data the user already saved
        Object object = request.getSession().getAttribute("employee");
        if ((object != null) && (object instanceof Employee)) {
            // let's used the data already modified by the user
            employee = (Employee) object;
        } else {
            // let's create new data for the user to play with
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            employee = new Employee();
            employee.setName("John Doe");
            employee.setSalary(40000.5);
            employee.setBirth(sdf.parse("09/25/1950"));
            employee.setHireDate(sdf.parse("02/15/1999"));
        }

        // log the raw info we're sending
        log.info("sending employee=" + employee);

        // create an action form containing our data formatted
        //  accd to the user's selected locale
        ActionForm employeeForm =
                FormUtils.setFormValues("employeeForm", employee,
                        this, mapping, request);

        // pass this to the JSP
        request.setAttribute("employeeForm",employeeForm);
        return mapping.findForward("showForm");
    }

}
