package formdef.plugin.config;

import formdef.plugin.conversion.Converter;

import java.io.Serializable;

import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.Log;

/**
 * @author Hubert Rabago
 */
public class GlobalConverterConfig implements Serializable {

    private static final Log log = LogFactory.getLog(GlobalConverterConfig.class);

    public static final int FOR_PROPERTY_TYPE = 0;
    public static final int FOR_PROPERTY_NAME = 1;
    public static final int FOR_CONVERTER_NAME = 2;

    private static final String FOR_PROPERTY_TYPE_STR = "property-type";
    private static final String FOR_PROPERTY_NAME_STR = "property-name";
    private static final String FOR_CONVERTER_NAME_STR = "converter-name";

    private int forValue;
    private String target;
    private String typeName;
    private Object converter;
    private String conversionParameter;
    private String conversionKey;
    private String conversionBundle;

    private Class targetClass;
    private boolean exactMatch = true;

    public int getForValue() {
        return forValue;
    }

    public void setForValue(int forValue) {
        this.forValue = forValue;
        log.trace("inside setForValue(int) where forValue=" + this.forValue);
    }

    public void setForValueString(String forValueString) {
        log.trace("inside setForValue(String) where forValueString=" + forValueString);
        if (FOR_PROPERTY_TYPE_STR.equals(forValueString)) {
            setForValue(FOR_PROPERTY_TYPE);
        } else if (FOR_PROPERTY_NAME_STR.equals(forValueString)) {
            setForValue(FOR_PROPERTY_NAME);
        } else if (FOR_CONVERTER_NAME_STR.equals(forValueString)) {
            setForValue(FOR_CONVERTER_NAME);
        } else {
            throw new IllegalArgumentException("Invalid forValueString parameter: " + forValueString);
        }
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
        if (typeName != null) {
            setConverter(getConverterInstance(typeName));
        }
    }

    protected void setConverter(Object converter) {
        this.converter = converter;
    }

    public Object getConverter() {
        return converter;
    }

    public String getConversionParameter() {
        return conversionParameter;
    }

    public void setConversionParameter(String conversionParameter) {
        this.conversionParameter = conversionParameter;
    }

    public String getConversionKey() {
        return conversionKey;
    }

    public void setConversionKey(String conversionKey) {
        this.conversionKey = conversionKey;
    }

    public String getConversionBundle() {
        return conversionBundle;
    }

    public void setConversionBundle(String conversionBundle) {
        this.conversionBundle = conversionBundle;
    }

    public Class getTargetClass() {
        return targetClass;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }


    /**
     * If this configuration is for a property type, whether this should
     * only be used for an exact match or should also be used for
     * assignable class types.
     * @return true if this configuration should only be used for exact
     *  class types as specified by the target.
     */
    public boolean isExactMatch() {
        return exactMatch;
    }

    /**
     * If this configuration is for a property type, set whether this should
     * only be used for an exact match or should also be used for
     * assignable class types.
     * @param exactMatch true to use this config only for exact class types
     * as specified by the target.
     */
    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
    }

    //public void setExactMatchString(String exactMatchStr) {
    //    log.trace(getTarget() + " exact match String: " + exactMatchStr);
    //    this.exactMatch = Boolean.getBoolean(exactMatchStr);
    //}

    /**
     * Return an instance of the specified class type using an empty constructor 
     * @param type the name of the class to instantiate
     * @return an instance of the specified class type
     */
    private static Converter getConverterInstance(String type) {
        try {
            Class converterClass = Class.forName(type);
            return (Converter) converterClass.getConstructor(new Class[]{}).newInstance(new Object[]{});
        } catch (Exception e) {
            log.error("Unable to create converter [" + type + "]", e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("GlobalConverterConfig [");
        result.append("forValue=").append(getForValue()).append(";");
        result.append("target=").append(getTarget()).append(";");
        result.append("typeName=").append(getTypeName()).append(";");
        result.append("converter=").append(getConverter()).append(";");
        result.append("conversionParameter=").append(getConversionParameter()).append(";");
        result.append("conversionKey=").append(getConversionKey()).append(";");
        result.append("conversionBundle=").append(getConversionBundle()).append(";");
        result.append("targetClass=").append(getTargetClass()).append(";");
        result.append("exactMatch=").append(isExactMatch()).append(";");
        result.append("]");
        return result.toString();
    }
}
