package formdef.plugin.conversion;


/**
 * {@link Converter} implementation for boolean values.
 * @author Hubert Rabago
 */
public class BooleanConverter implements Converter {
    private static final String[] TRUE_VALUES = {"true","on","yes","1"};
    private static final String[] FALSE_VALUES = {"false","off","no","0"};

    /**
     * <p>Convert boolean to String and vice-versa.</p>
     *
     * @param context the {@link ConversionContext} holding information
     * about the value to convert and additional conversion parameters
     * @return the equivalent of the given value, in the specified type
     */
    public Object convert(ConversionContext context) {
        Object value = context.getValue();
        Class type = context.getType();
        String propertyName = context.getPropertyName();

        if ((value == null) || ((value instanceof String) && (((String)value).length() <= 0))) {
            if ((type.equals(Boolean.class)) || (type.equals(String.class))){
                return null;
            } else if (type.equals(Boolean.TYPE)) {
                return Boolean.FALSE;
            } else {
                throw new IllegalArgumentException(
                        "Unsupported type parameter: " + type
                        + " for property " + propertyName);
            }
        }

        if ((type.equals(Boolean.class)) || (type.equals(Boolean.TYPE))) {
            String theValue=value.toString();
            for (int i=0; i<TRUE_VALUES.length; i++) {
                if (TRUE_VALUES[i].equalsIgnoreCase(theValue))
                    return Boolean.TRUE;
            }
            for (int i=0; i<FALSE_VALUES.length; i++) {
                if (FALSE_VALUES[i].equalsIgnoreCase(theValue))
                    return Boolean.FALSE;
            }
            
            return Boolean.valueOf((String)value);
        } else if (type.equals(String.class)) {
            return value.toString();
        } else {
            throw new IllegalArgumentException(
                    "Unsupported type parameter: " + type
                    + " for property " + propertyName);
        }
    }

}
