package formdef.plugin.conversion;

/**
 * {@link Converter} implementation for character values and Character objects.
 */
public class CharacterConverter implements Converter {

    /**
     * <p>{@link Converter#convert convert} implementation for character values
     * and Character objects.</p>
     *
     * @param context the {@link ConversionContext} holding information
     * about the value to convert and additional conversion parameters
     * @return the equivalent of the given value, in the specified type
     */
    public Object convert(ConversionContext context) {
        Object value = context.getValue();
        Class type = context.getType();
        String propertyName = context.getPropertyName();

        if ((value == null) || ((value instanceof String) && (((String)value).length() <= 0))) {
           if ( (type.equals(Character.TYPE))) {
               return new Character((char)0);
           } else if ((type.equals(String.class) || type.equals(Character.class))) {
               return null;
           } else {
               throw new IllegalArgumentException(
                       "Unsupported type parameter: " + type
                       + " for property " + propertyName);
           }
       }


        if ((type.equals(Character.class)) || (type.equals(Character.TYPE))) {
            return new Character(((String)value).charAt(0));
        } else if (type.equals(String.class)) {
            return value.toString();
        } else {
            throw new IllegalArgumentException(
                    "Unsupported type parameter: " + type
                    + " for property " + propertyName);
        }
    }

}

