package formdef.plugin.conversion;

/**
 * <p>Interface for objects used to convert between formatted String for 
 * a form bean and a typed field for a business object.</p>
 * 
 * @author Hubert Rabago
 */
public interface Converter {

    /**
     * <p>Converts the value to the specified type.</p>
     * 
     * @param context the {@link ConversionContext} holding information
     * about the value to convert and additional conversion parameters
     * @return the equivalent of the given value, in the specified type
     */
    public Object convert(ConversionContext context)
            throws Exception;

}
