package formdef.plugin.conversion;

import formdef.plugin.util.FormUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.beanutils.DynaBean;

import javax.servlet.http.HttpServletRequest;

/**
 * {@link Converter} implementation for a nested form.
 */
public class FormConverter
        implements Converter {

    private static final Log log = LogFactory.getLog(FormConverter.class);

    
    /**
     * <p>Converts an ActionForm to a typed bean and vice-versa using
     * FormUtils.</p>
     *
     * @param context the {@link ConversionContext} holding information
     *                about the value to convert and additional conversion parameters.
     * @return the equivalent of the given value, in the specified type; if
     *         the given value is null, null is returned as well.
     */
    public Object convert(ConversionContext context)
            throws Exception {

        Object value = context.getValue();
        String propertyName = context.getPropertyName();
        Class type = context.getType();
        Object param = context.getParam();
        Action action = context.getAction();
        ActionMapping mapping = context.getMapping();
        HttpServletRequest request = context.getRequest();

        if (log.isTraceEnabled()) {
            log.trace("converting [" + propertyName + "] to type [" + type + "] using param=[" + param + "]");
        }

        if (param == null) {
            log.trace("param is null.");
            return null;
        } else if (value == null) {
            log.trace("value is null.");
            return null;
        }

        if (value instanceof DynaBean) {
            DynaBean daf = (DynaBean) value;
            if (daf.getDynaClass() == null) {
                log.trace("DynaClass is null.");
                return null;
            }
        }

        // are we converting from an ActionForm to a business bean?
        if (value instanceof ActionForm) {
            ActionForm form = (ActionForm) value;
            return FormUtils.getFormValues(form, (String) param,
                    action, mapping, request);
        } else {
            return FormUtils.setFormValues((String) param,
                    value, action, mapping, request);
        }

    }

}

