package formdef.plugin.util;

import java.util.Locale;

/**
 * Utility object for finding the correct Locale to use for a particular
 * conversion parameter.
 * <p/>
 * Objects of this interface are used when a field's conversion parameter 
 * is provided in a message resource file.  Resource files may be present 
 * for some locales and not others; implementations of this interface
 * will provide the Locale that matches the conversion parameter available
 * for a given locale and conversionKey combination.
 * <p/>
 * For example, an application's default Locale is EN.  A form contains a 
 * conversion parameter for a double field.  The conversion formats are:
 * <br/>
 * default (EN) properties file: <code>###,##0.00</code><br/> 
 * DE properties file: <code>#####0,00</code><br/>
 * IT properties file: <code>###.##0,00</code><br/>
 * <p/> 
 * If a user's browser is set to the FR locale, the default conversion 
 * parameter will be used.  In order to work properly, the DecimalFormat
 * that will be used during formatting and parsing should return the locale
 * matching the conversion parameter, EN, which is incompatible with the FR 
 * locale. The {@link #getLocale(Locale,String)} method should return the 
 * Locale that matches the conversion parameter for a the user's locale 
 * and a given conversion key.
 */
public interface ResourceLocaleUtil {
    
    /**
     * Determine the {@link Locale} object that should be used for the
     * given conversionParameter when the user's locale is the given
     * <code>locale</code>.
     * @param locale the locale of the user for which conversion will be done
     * @param conversionKey the resource key containing the conversion
     *      parameter that will be used for a conversion
     * @return the Locale to be used for the given conversionKey
     */ 
    Locale getLocale(Locale locale, String conversionKey);
    
}
