package formdef.plugin.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.ServletContext;

/**
 * The interface for a factory object that provides {@link ResourceLocaleUtil} 
 * implementation classes. 
 */
public interface ResourceLocaleUtilFactory {
    
    /**
     * Provide the ResourceLocaleUtil that will be used for conversion 
     * parameters in the named resource bundle for the current request.
     * <p/>
     * @param request the request being processed
     * @param servletContext the current {@link javax.servlet.ServletContext}
     * @param bundle the bundle key, can be null for the default bundle 
     * @return the {@link ResourceLocaleUtil} instance to use for the given
     *  module and bundle
     */ 
    ResourceLocaleUtil getLocaleUtil(HttpServletRequest request,
                                     ServletContext servletContext,
                                     String bundle);
    
}
