package formdef.plugin.sample;

import formdef.plugin.util.FormUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;

/**
 * @author Hubert Rabago
 */
public class SampleFormUtils extends FormUtils {
    
    // counters for the methods that should be called by FormUtils
    protected int setFormValuesCounter = 0;
    protected int getFormValuesCounter = 0;

    public int getSetFormValuesCounter() {
        return setFormValuesCounter;
    }

    public int getGetFormValuesCounter() {
        return getFormValuesCounter;
    }


    /**
     * <p>Implementation of the {@link #setFormValues} static method.
     * Prepares the dyna form by acquiring an instance and populating it 
     * with values from the provided source object.</p>
     * 
     * @param formName the name of the formbean
     * @param source the object holding the values to be used for the formbean
     * @param action the current action
     * @param mapping the current ActionMapping
     * @param request the request being processed
     */
    public ActionForm setFormValuesImpl(
            String formName,
            Object source,
            Action action,
            ActionMapping mapping,
            HttpServletRequest request)
            throws IllegalAccessException, InvocationTargetException {
        setFormValuesCounter++;
        return super.setFormValuesImpl(formName, source, action, mapping, request);
    }

    /**
     * <p>Implementation of the {@link #getFormValues} static method.
     * Creates the object which contains the values held by the given
     * actionForm.</p>
     * 
     * @param actionForm a {@link DynaActionForm}
     * @param action the action currently executing
     * @param mapping the mapping to which the form was submitted
     * @param request the request being processed
     * @return an object holding the values from the actionForm
     * @throws IllegalAccessException if access modifiers for the object's
     *   constructor, factory, or setter methods are inaccessible
     * @throws InvocationTargetException if the return object's constructor,
     *   factory, or setter methods throw an exception when called
     */
    public Object getFormValuesImpl(
            ActionForm actionForm,
            Action action,
            ActionMapping mapping,
            HttpServletRequest request)
            throws IllegalAccessException, InvocationTargetException {
        getFormValuesCounter++;
        return super.getFormValuesImpl(actionForm, action, mapping, request);
    }

}
