package formdef.plugin.util;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.Action;
import org.apache.struts.mock.MockServletContext;
import org.apache.struts.mock.MockHttpServletRequest;
import org.apache.struts.mock.MockHttpSession;
import org.apache.struts.mock.MockActionServlet;
import org.apache.struts.mock.MockAction;
import org.apache.struts.Globals;
import formdef.plugin.sample.SampleBean1;
import formdef.plugin.sample.SampleBean2;
import formdef.plugin.sample.SubActionForm;
import formdef.plugin.sample.SampleBean1Factory;
import formdef.plugin.sample.SampleFormUtilsFactory;
import formdef.plugin.sample.SampleFormUtils;
import formdef.plugin.sample.MultiSampleBeanA;
import formdef.plugin.config.GlobalConverterConfig;
import formdef.plugin.config.PropertyMappingConfig;
import formdef.plugin.config.FormMappingConfig;
import formdef.plugin.config.FormDefConfig;
import formdef.plugin.FormMapping;

import java.util.Locale;
import java.text.SimpleDateFormat;

/**
 * @author Hubert Rabago
 */
public class TestFormUtils extends TestCase {

    //*****************************
    // the usual suspects

    public TestFormUtils(String s) {
        super(s);
    }

    public static TestSuite getSuite() {
        return new TestSuite(TestFormUtils.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner runner = new junit.textui.TestRunner();
        runner.doRun(TestFormUtils.getSuite());
    }



    //*****************************

    protected GlobalConverterConfig mdyConverter = null;
    protected GlobalConverterConfig propertyNamedConverter = null;
    protected GlobalConverterConfig namedConverter = null;
    protected FormMappingConfig sampleBean1FormConfig = null;
    protected FormMappingConfig sampleBean2FormConfig = null;
    protected FormMappingConfig dynaForm1Config = null;
    protected FormMappingConfig subActionForm1Config = null;
    protected FormMappingConfig multiSampleBeanAFormConfig = null;
    
    // instance vars used for testing createObjectInstance
    protected FormMappingConfig formWithFactory = null;
    protected FormMappingConfig formWithFactoryParam = null;
    protected FormMappingConfig formWithNoFactory = null;
    
   
    /** the instance used for tests that do not change the configuration */
    protected FormDefConfig testConfig = null;
    
    /** mock servlet objects */
    protected MockServletContext servletContext = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpSession session = null;
    protected Locale locale = null;
    
    /** empty module config */
    protected ModuleConfig moduleConfig = null;
    protected Action action = null;
    protected MockActionServlet actionServlet;
    
    protected ActionMapping mapping = null;
    protected ActionMapping sampleBean1Mapping = null;
    protected ActionMapping sampleBean2Mapping = null;

    public void setUp()
            throws Exception {
        super.setUp();
        
        // Configure a global M/d/yyyy date converter
        mdyConverter = new GlobalConverterConfig();
        mdyConverter.setForValue(GlobalConverterConfig.FOR_PROPERTY_TYPE);
        mdyConverter.setTarget(java.util.Date.class.getName());
        mdyConverter.setConversionParameter("M/d/yyyy");

        // Configure a global converter for a property name
        propertyNamedConverter = new GlobalConverterConfig();
        propertyNamedConverter.setForValue(
                GlobalConverterConfig.FOR_PROPERTY_NAME);
        propertyNamedConverter.setTarget("fDouble");
        propertyNamedConverter.setConversionParameter("#####0.00");

        // Configure a global named converter
        namedConverter = new GlobalConverterConfig();
        namedConverter.setForValue(
                GlobalConverterConfig.FOR_CONVERTER_NAME);
        namedConverter.setTarget("namedConverter");
        namedConverter.setConversionParameter("###,##0.00");

        // Configure a few simple FormDefFormConfigs
        sampleBean1FormConfig =
                new FormMappingConfig("sampleBean1", SampleBean1.class.getName());

        sampleBean2FormConfig = 
                new FormMappingConfig("sampleBean2", SampleBean2.class.getName());
        
        multiSampleBeanAFormConfig = 
                new FormMappingConfig("multiSampleBeanA", MultiSampleBeanA.class.getName());
        
        // Configure a form not tied to a bean
        dynaForm1Config = new FormMappingConfig();
        dynaForm1Config.setName("dynaForm1Config");
        dynaForm1Config.setFormType(DynaActionForm.class.getName());
        PropertyMappingConfig prop = new PropertyMappingConfig();
        prop.setName("firstName");
        dynaForm1Config.addProperty(prop);
        prop = new PropertyMappingConfig();
        prop.setName("lastName");
        dynaForm1Config.addProperty(prop);
        
        // create a prop with an initial value
        prop = new PropertyMappingConfig();
        prop.setName("sex");
        prop.setInitial("M");
        dynaForm1Config.addProperty(prop);
        
        // create a prop with a size value
        prop = new PropertyMappingConfig();
        prop.setName("languages");
        prop.setSize("5");
        dynaForm1Config.addProperty(prop);
        
        // Configure an ActionForm subclass that's not a dynaForm
        subActionForm1Config = new FormMappingConfig();
        subActionForm1Config.setName("subActionForm1Config");
        subActionForm1Config.setFormType(SubActionForm.class.getName());
        
        
        // Configure the forms for createObjectInstance()
        formWithFactory = 
                new FormMappingConfig("formWithFactory", 
                        SampleBean1.class.getName());
        formWithFactory.setFactory("formdef.plugin.sample.SampleBean1Factory");
        formWithFactory.setFactoryMethodName("factoryMethodNoParam");
        
        formWithFactoryParam = 
                new FormMappingConfig("formWithFactoryParam", 
                        SampleBean1.class.getName());
        formWithFactoryParam.setFactory("formdef.plugin.sample.SampleBean1Factory");
        formWithFactoryParam.setFactoryMethodName("factoryMethodWithParam");
        formWithFactoryParam.setFactoryMethodNameParam("true");

        formWithNoFactory = 
                new FormMappingConfig("formWithNoFactory", 
                        SampleBean1.class.getName());
        
        // Configure a FormDefConfig that can be shared among tests that
        //  do not change the config
        testConfig = new FormDefConfig();
        testConfig.addConverter(mdyConverter);
        testConfig.addConverter(propertyNamedConverter);
        testConfig.addConverter(namedConverter);
        testConfig.addForm(sampleBean1FormConfig);
        testConfig.addForm(sampleBean2FormConfig);
        testConfig.addForm(multiSampleBeanAFormConfig);
        testConfig.addForm(formWithFactory);
        testConfig.addForm(formWithFactoryParam);
        testConfig.addForm(formWithNoFactory);
        
        // prepare a module config
        moduleConfig = 
                ModuleConfigFactory.createFactory().createModuleConfig("");

        testConfig.registerForms(moduleConfig);

        // prepare the mock servlet objects
        servletContext = new MockServletContext();
        session = new MockHttpSession(servletContext);
        locale = Locale.getDefault();
        request = new MockHttpServletRequest(session);
        request.setLocale(locale);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        
        // store our config in the servlet context
        servletContext.setAttribute(
                FormDefConfig.FORMDEF_KEY + moduleConfig.getPrefix(),
                testConfig);
        servletContext.setAttribute(
                Globals.MODULE_KEY + moduleConfig.getPrefix(),
                moduleConfig);
    
        action = new MockAction();
        actionServlet = new MockActionServlet();
        actionServlet.setServletContext(servletContext);
        action.setServlet(actionServlet);
        
        mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        
        // Configure mappings related to our four forms
        sampleBean1Mapping = new ActionMapping();
        sampleBean1Mapping.setName(sampleBean1FormConfig.getName());
        sampleBean1Mapping.setModuleConfig(moduleConfig);
        
        sampleBean2Mapping = new ActionMapping();
        sampleBean2Mapping.setName(sampleBean2FormConfig.getName());
        sampleBean2Mapping.setModuleConfig(moduleConfig);
        
        // reset FormUtils here
        resetFormUtilsInstance();
    }


    protected void tearDown() throws Exception {
        resetFormUtilsInstance();
    }

    private void resetFormUtilsInstance() {
        // Reset the FormUtils instance variable
        FormUtils.setFactoryClassName(FormUtilsFactoryImpl.class.getName());
        FormUtils.instance = null;
    }

    /**
     * Test calling the setFormValues of an installed FormUtils extension.
     */ 
    public void testInstalledSetFormValues() 
            throws Exception {
        
        FormUtils.setFactoryClassName(SampleFormUtilsFactory.class.getName());

        // get our FormUtils object
        SampleFormUtils sampleFormUtils = (SampleFormUtils)
                FormUtils.getInstance();
        
        // check the pre-call counts
        int setFormValuesCounter = sampleFormUtils.getSetFormValuesCounter();
                
        // prepare a bean to set
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        java.util.Date date = sdf.parse("12/01/2004");
        
        // prepare the bean from which values should come from
        SampleBean2 sampleBean2 = new SampleBean2();
        sampleBean2.setfInt(1);
        sampleBean2.setfDouble(15);
        sampleBean2.setfString("Sample Value");
        sampleBean2.setfDate(date);
        
        // call the static method
        FormUtils.setFormValues(sampleBean2FormConfig.getName(),
                        sampleBean2, action, mapping, request);
        
        // check that our installed FormUtils extension got called
        assertTrue("Installed FormUtils extension not called",
                setFormValuesCounter+1 == sampleFormUtils.getSetFormValuesCounter());
    }

    /**
     * Test calling the getFormValues of an installed FormUtils extension.
     */ 
    public void testInstalledGetFormValues() 
            throws Exception {
        
        FormUtils.setFactoryClassName(SampleFormUtilsFactory.class.getName());

        // get our FormUtils object
        SampleFormUtils sampleFormUtils = (SampleFormUtils)
                FormUtils.getInstance();
        
        // check the pre-call counts
        int getFormValuesCounter = sampleFormUtils.getGetFormValuesCounter();
                
        // prepare a form we can use for calling getFormValues()
        DynaActionForm form = (DynaActionForm)
                sampleFormUtils.createActionForm(
                        sampleBean1FormConfig.getName(), 
                        action, mapping, request);
        form.set("fInt","1");
        form.set("fString","2");
        form.set("fDouble","3.0");
        
        mapping.setName(sampleBean1FormConfig.getName());

        // call the static method
        FormUtils.getFormValues(form, action, mapping, request);
        
        // check that our installed FormUtils extension got called
        assertTrue("Installed FormUtils extension not called",
                getFormValuesCounter+1 == sampleFormUtils.getGetFormValuesCounter());
    }

    public void testFindFormDefinition() 
            throws Exception {
        
        FormMapping actual = 
                new FormUtils().findFormDefinition(
                        sampleBean1FormConfig.getName(), 
                        servletContext, 
                        moduleConfig);
        assertEquals("Didn't find the correct form",
                actual.getName(), sampleBean1FormConfig.getName());
    }
    
    
    /** 
     * A very simple test for lookupFormName.
     */ 
    public void testLookupFormName() {
        
        String formName = FormUtils.lookupFormName(new SampleBean2(),
                action, mapping);
        assertEquals("Wrong form name found", "sampleBean2", formName);
        
        formName = FormUtils.lookupFormName(new MultiSampleBeanA(),
                action, mapping);
        assertEquals("Wrong form name found", "multiSampleBeanA", formName);
    }
    
    
    /**
     * <p>Test that the form is being created and a call to populateForm is
     * being made.<p/>
     * <p><b>Note</b>: populateForm is not tested here.</p>  
     */ 
    public void testSetFormValues() 
            throws Exception {
        
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        java.util.Date date = sdf.parse("12/01/2004");
        
        // prepare the bean from which values should come from
        SampleBean2 sampleBean2 = new SampleBean2();
        sampleBean2.setfInt(1);
        sampleBean2.setfDouble(15);
        sampleBean2.setfString("Sample Value");
        sampleBean2.setfDate(date);
        
        // whew! create the form
        DynaActionForm form = (DynaActionForm) 
                new FormUtils().setFormValuesImpl(
                        sampleBean2FormConfig.getName(),
                        sampleBean2, 
                        action,
                        mapping,
                        request);
        
        // check that it's got the right values just to make sure
        //  that what's in there really got populated
        assertEquals("Incorrect form values",
                "1", form.get("fInt"));
        assertEquals("Incorrect form values",
                "15.00", form.get("fDouble"));
        assertEquals("Incorrect form values",
                "Sample Value", form.get("fString"));
        assertEquals("Incorrect form values",
                "12/1/2004", form.get("fDate"));
    }


    /**
     * Test findDynaActionForm() when the form is in request scope.
     */ 
    /*
    public void testFindDynaActionFormRequestScope () {
        
        FormUtils formUtils = new FormUtils();
        // first, we need a form
        DynaActionForm form = formUtils.createDynaActionForm(
                sampleBean1FormConfig.getName(), moduleConfig);
        
        // put it in request scope
        request.setAttribute(sampleBean1FormConfig.getName(), form);
        
        // see if formUtils can find it
        DynaActionForm actual = formUtils.findDynaActionForm(
                sampleBean1FormConfig.getName(),
                sampleBean1FormConfig.getName(),
                moduleConfig, 
                request);
        
        assertSame("Can't find the form in request scope",
                form, actual);
    }
    */
    
    /**
     * Test findDynaActionForm() when the form is in session scope.
     */ 
    /*
    public void testFindDynaActionFormSessionScope () {
        
        FormUtils formUtils = new FormUtils();
        
        // first, we need a form
        DynaActionForm form = formUtils.createDynaActionForm(
                sampleBean1FormConfig.getName(), moduleConfig);
        
        // put it in session scope
        session.setAttribute(sampleBean1FormConfig.getName(), form);
        
        // see if formUtils can find it
        DynaActionForm actual = formUtils.findDynaActionForm(
                sampleBean1FormConfig.getName(),
                sampleBean1FormConfig.getName(),
                moduleConfig, 
                request);
        
        assertSame("Can't find the form in session scope",
                form, actual);
    }
    */
    

    public void testCreateObjectInstanceWithFactory() 
            throws Exception {
        FormUtils formUtils = new FormUtils();
        FormMapping formMapping = 
                formUtils.findFormDefinition(formWithFactory.getName(),
                        servletContext, moduleConfig);

        assertNotNull("No factory found",formMapping.getFactory());
        assertTrue("Invalid factory found",formMapping.getFactory() instanceof SampleBean1Factory);

        Object object = formUtils.createObjectInstance(formMapping);
        
        assertNotNull("No objects returned",object);
        assertTrue("Invalid object type",object instanceof SampleBean1);
        
        SampleBean1 sampleBean1 = (SampleBean1) object;
        assertTrue("Factory method not called",
                "factoryMethodNoParam".equals(sampleBean1.getfString()));
    }

    public void testCreateObjectInstanceWithFactoryParam() 
            throws Exception {
        FormUtils formUtils = new FormUtils();
        FormMapping formMapping = 
                formUtils.findFormDefinition(formWithFactoryParam.getName(),
                        servletContext, moduleConfig);

        assertNotNull("No factory found",formMapping.getFactory());
        assertTrue("Invalid factory found",formMapping.getFactory() instanceof SampleBean1Factory);

        Object object = formUtils.createObjectInstance(formMapping);
        
        assertNotNull("No objects returned",object);
        assertTrue("Invalid object type",object instanceof SampleBean1);
        
        SampleBean1 sampleBean1 = (SampleBean1) object;
        assertTrue("Factory method not called",
                formWithFactoryParam.getName().equals(sampleBean1.getfString()));
    }

    public void testCreateObjectInstanceWithNoFactory() 
            throws Exception {
        FormUtils formUtils = new FormUtils();
        FormMapping formMapping = 
                formUtils.findFormDefinition(formWithNoFactory.getName(),
                        servletContext, moduleConfig);
        Object object = formUtils.createObjectInstance(formMapping);
        
        assertNotNull("No objects returned",object);
        assertTrue("Invalid object type",object instanceof SampleBean1);
        
        SampleBean1 sampleBean1 = (SampleBean1) object;
        assertTrue("Invalid field value expected; factory may have been called.",
                sampleBean1.getfString() == null);
    }
    
}
