package formdef.plugin.util;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.Action;
import org.apache.struts.mock.MockServletContext;
import org.apache.struts.mock.MockHttpServletRequest;
import org.apache.struts.mock.MockHttpSession;
import org.apache.struts.mock.MockActionServlet;
import org.apache.struts.mock.MockAction;
import org.apache.struts.Globals;

import formdef.plugin.config.*;
import formdef.plugin.sample.TypeSampler;
import formdef.plugin.sample.MultiSampleBeanA;
import formdef.plugin.sample.SubSqlDate;
import formdef.plugin.sample.Sex;
import formdef.plugin.digester.DefaultDigester;

import java.util.Locale;
import java.text.SimpleDateFormat;
import java.io.InputStream;
import java.io.BufferedInputStream;

/**
 * Tests the populateForm() method of FormUtils.
 */
public class TestFormUtilsPopulateForm extends TestCase {

    //*****************************
    // the usual suspects

    public TestFormUtilsPopulateForm(String s) {
        super(s);
    }

    public static TestSuite getSuite() {
        return new TestSuite(TestFormUtilsPopulateForm.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner runner = new junit.textui.TestRunner();
        runner.doRun(TestFormUtilsPopulateForm.getSuite());
    }



    //*****************************

    protected GlobalConverterConfig mdyConverter = null;

    TypeSampler typeSampler1 = null;
    protected FormMappingConfig typeSampler1FormConfig = null;
    protected FormMappingConfig typeSampler2FormConfig = null;
   
    protected FormDefConfig testConfig = null;
    
    /** mock servlet objects */
    protected MockServletContext servletContext = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpSession session = null;
    protected Locale locale = null;
    
    /** empty module config */
    protected ModuleConfig moduleConfig = null;

    protected Action action = null;
    MockActionServlet actionServlet = null;
    protected ActionMapping mapping = null;

    public void setUp()
            throws Exception {
        super.setUp();

        String filename = "formdef/plugin/util/form-utils-populate-form.xml";
        //ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        //if (classLoader == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
        //}
        InputStream is = classLoader.getResourceAsStream(filename);
        testConfig = new FormDefConfig();
        DefaultDigester.readConfiguration(testConfig, new BufferedInputStream(is));
        is.close();

        // prepare a module config
        moduleConfig = 
                ModuleConfigFactory.createFactory().createModuleConfig("");

        testConfig.registerForms(moduleConfig);

        // prepare the mock servlet objects
        servletContext = new MockServletContext();
        session = new MockHttpSession(servletContext);
        locale = Locale.getDefault();
        request = new MockHttpServletRequest(session);
        request.setLocale(locale);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // store our config in the servlet context
        servletContext.setAttribute(
                FormDefConfig.FORMDEF_KEY + moduleConfig.getPrefix(),
                testConfig);
        servletContext.setAttribute(
                Globals.MODULE_KEY + moduleConfig.getPrefix(),
                moduleConfig);
        
        action = new MockAction();
        actionServlet = new MockActionServlet();
        actionServlet.setServletContext(servletContext);
        action.setServlet(actionServlet);

        // Configure an action mapping we can use
        mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);

        // create out type sampler
        typeSampler1 = new TypeSampler();
        typeSampler1.setInt1(1);
        typeSampler1.setLong1(2);
        typeSampler1.setDouble1(3);
        typeSampler1.setFloat1(4);
        typeSampler1.setByte1((byte) 5);
        typeSampler1.setShort1((short) 6);
        typeSampler1.setChar1('7');
        typeSampler1.setString1("8");
        typeSampler1.setBoolean1(false);

        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        java.util.Date date = sdf.parse("12/01/2004");
        typeSampler1.setDate1(date);

        typeSampler1.setIntWrapper1(new Integer(11));
        typeSampler1.setLongWrapper1(new Long(12));
        typeSampler1.setDoubleWrapper1(new Double(13));
        typeSampler1.setFloatWrapper1(new Float(14));
        typeSampler1.setByteWrapper1(new Byte((byte) 15));
        typeSampler1.setShortWrapper1(new Short((short) 16));
        typeSampler1.setCharWrapper1(new Character('7'));
        typeSampler1.setBooleanWrapper1(new Boolean(false));
    }

    
    // **********************************
    //    testPopulateFormXYZ methods

    /**
     * Basic test of all the primitive types (and their wrappers)
     */
    public void testPopulateFormTypeSampler()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("typeSampler1",
                        action, mapping, request);
        
        formUtils.populateForm("typeSampler1",
                form, typeSampler1, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("int1"));
        assertEquals("Incorrect form value", "2", form.get("long1"));
        assertEquals("Incorrect form value", "3.0", form.get("double1"));
        assertEquals("Incorrect form value", "4.0", form.get("float1"));
        assertEquals("Incorrect form value", "5", form.get("byte1"));
        assertEquals("Incorrect form value", "6", form.get("short1"));
        assertEquals("Incorrect form value", "7", form.get("char1"));
        assertEquals("Incorrect form value", "8", form.get("string1"));
        assertEquals("Incorrect form value", "false", form.get("boolean1"));
        assertEquals("Incorrect form value", "12/01/2004", form.get("date1"));
        assertEquals("Incorrect form value", "11", form.get("intWrapper1"));
        assertEquals("Incorrect form value", "12", form.get("longWrapper1"));
        assertEquals("Incorrect form value", "13.0", form.get("doubleWrapper1"));
        assertEquals("Incorrect form value", "14.0", form.get("floatWrapper1"));
        assertEquals("Incorrect form value", "15", form.get("byteWrapper1"));
        assertEquals("Incorrect form value", "16", form.get("shortWrapper1"));
        assertEquals("Incorrect form value", "7", form.get("charWrapper1"));
        assertEquals("Incorrect form value", "false", form.get("booleanWrapper1"));
    }

    /**
     * See if the conversion params are passed to converters
     */
    public void testPopulateFormFormattedField()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("typeSampler2",
                        action, mapping, request);
        
        TypeSampler temp = TypeSampler.createClone(typeSampler1);
        temp.setDouble1(1234567.8);
        temp.setDate1(new SimpleDateFormat("MM/dd/yyyy").parse("12/03/2004"));
        
        formUtils.populateForm("typeSampler2",
                form, temp, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1,234,567.8000", form.get("double1"));
        assertEquals("Incorrect form value", "20041203", form.get("date1"));
    }

    /**
     * See if fields with no converters are skipped as expected
     */
    public void testPopulateFormNullConverter()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("multiSampleBeanA1",
                        action, mapping, request);
        
        SubSqlDate date = new SubSqlDate(new SimpleDateFormat("MM/dd/yyyy").parse("12/03/2004").getTime());
        MultiSampleBeanA multiSampleBeanA = new MultiSampleBeanA(1,"2",3.0,date);
        
        formUtils.populateForm("multiSampleBeanA1",
                form, multiSampleBeanA, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("int1"));
        assertEquals("Incorrect form value", "2", form.get("string1"));
        assertEquals("Incorrect form value", "", form.get("subSqlDate1"));
        assertEquals("Incorrect form value", "", form.get("sex1"));
        
        try {
            form.get("double1");
            assertTrue("Accessed inaccesible property", false);
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * See if the expected exception is thrown when formatting dates
     * without specifying a date format.
     */
    public void testPopulateFormNoDateFormat()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("multiSampleBeanA2",
                        action, mapping, request);
        
        SubSqlDate date = new SubSqlDate(new SimpleDateFormat("MM/dd/yyyy").parse("12/03/2004").getTime());
        MultiSampleBeanA multiSampleBeanA = new MultiSampleBeanA(1,"2",3.0,date);
        
        try {
            formUtils.populateForm("multiSampleBeanA2",
                    form, multiSampleBeanA, moduleConfig, action, null, request);
            assertTrue("Expected exception when formatting a date without a specified format", false);
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * Test the setting of fields that use accessor methods that do not follow
     * JavaBean conventions.
     */
    public void testPopulateFormUnconventionalAccessors()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("multiSampleBeanA3",
                        action, mapping, request);
        
        SubSqlDate date = new SubSqlDate(new SimpleDateFormat("MM/dd/yyyy").parse("12/03/2004").getTime());
        MultiSampleBeanA multiSampleBeanA = new MultiSampleBeanA(1,"2",3.0,date);
        
        formUtils.populateForm("multiSampleBeanA3",
                form, multiSampleBeanA, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("int1"));
        assertEquals("Incorrect form value", "2", form.get("string1"));
        assertEquals("Incorrect form value", "20041203", form.get("subSqlDate1"));
        assertEquals("Incorrect form value", "3.0", form.get("double1"));
    }

    /**
     * Test the setting of fields that use custom converters.
     */
    public void testPopulateFormCustomConverter()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("multiSampleBeanA4",
                        action, mapping, request);
        
        SubSqlDate date = new SubSqlDate(new SimpleDateFormat("MM/dd/yyyy").parse("12/03/2004").getTime());
        MultiSampleBeanA multiSampleBeanA = new MultiSampleBeanA(1,"2",3.0,date);
        multiSampleBeanA.setSex1(Sex.MALE);
        
        formUtils.populateForm("multiSampleBeanA4",
                form, multiSampleBeanA, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "M", form.get("sex1"));
    }

    /**
     * Expect an error to be thrown when we can't find the form def.
     */
    public void testPopulateFormNoFormDefinition()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("multiSampleBeanA1",
                        action, mapping, request);

        SubSqlDate date = new SubSqlDate(new SimpleDateFormat("MM/dd/yyyy").parse("12/03/2004").getTime());
        MultiSampleBeanA multiSampleBeanA = new MultiSampleBeanA(1,"2",3.0,date);

        try {
            formUtils.populateForm("nonExistingForm", 
                    form, multiSampleBeanA, moduleConfig, action, null, request);
            assertTrue("Found non-existing form", false);
        } catch (IllegalArgumentException e) {
        }
    }
    
    
    /**
     * Test the setting of typed fields 
     */ 
    public void testPopulateFormTypedFields() 
            throws Exception {
        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("multiSampleBeanA5",
                        action, mapping, request);
        
        SubSqlDate date = new SubSqlDate(new SimpleDateFormat("MM/dd/yyyy").parse("12/03/2004").getTime());
        MultiSampleBeanA multiSampleBeanA = new MultiSampleBeanA(1,"2",3.0,date);
        multiSampleBeanA.setSex1(Sex.MALE);
        
        formUtils.populateForm("multiSampleBeanA5",
                form, multiSampleBeanA, moduleConfig, action, null, request);

        // int1 should be skipped because we don't have a converter for java.lang.Integer
        assertNull("Incorrect form value", form.get("int1"));
    }
    

    //  end of testPopulateFormXYZ methods
    // **********************************

}
