package formdef.plugin.util;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.Action;
import org.apache.struts.mock.MockServletContext;
import org.apache.struts.mock.MockHttpServletRequest;
import org.apache.struts.mock.MockHttpSession;
import org.apache.struts.mock.MockAction;
import org.apache.struts.Globals;
import org.apache.struts.util.ModuleUtils;

import formdef.plugin.config.*;
import formdef.plugin.sample.SampleBean2;
import formdef.plugin.digester.DefaultDigester;
import formdef.plugin.mock.MockActionServlet;

import java.util.Locale;
import java.text.SimpleDateFormat;
import java.io.InputStream;
import java.io.BufferedInputStream;

/**
 * Tests the populateForm() method of FormUtils using different locales.
 */
public class TestFormUtilsPopulateFormLocale extends TestCase {

    //*****************************
    // the usual suspects

    public TestFormUtilsPopulateFormLocale(String s) {
        super(s);
    }

    public static TestSuite getSuite() {
        return new TestSuite(TestFormUtilsPopulateFormLocale.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner runner = new junit.textui.TestRunner();
        runner.doRun(TestFormUtilsPopulateFormLocale.getSuite());
    }



    //*****************************

    protected GlobalConverterConfig mdyConverter = null;

    SampleBean2 sampleBean2a = null;
    protected FormMappingConfig sampleBean2aFormConfig = null;
    protected FormMappingConfig sampleBean2bFormConfig = null;
   
    protected FormDefConfig testConfig = null;
    
    /** mock servlet objects */
    protected MockServletContext servletContext = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpSession session = null;

    protected Locale locale = null;
    
    /** empty module config */
    protected ModuleConfig moduleConfig = null;

    protected Action action = null;
    MockActionServlet actionServlet = null;
    protected ActionMapping mapping = null;

    public void setUp()
            throws Exception {
        super.setUp();

        String filename = "formdef/plugin/util/form-utils-populate-form-locale.xml";
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream(filename);
        testConfig = new FormDefConfig();
        DefaultDigester.readConfiguration(testConfig, new BufferedInputStream(is));
        is.close();

        // prepare a module config
        moduleConfig = 
                ModuleConfigFactory.createFactory().createModuleConfig("");
        moduleConfig.setPrefix("");

        testConfig.registerForms(moduleConfig);

        // prepare the mock servlet objects
        servletContext = new MockServletContext();
        session = new MockHttpSession(servletContext);
        locale = Locale.getDefault();
        request = new MockHttpServletRequest(session);
        request.setLocale(locale);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        
        // store our config objects in the servlet context
        servletContext.setAttribute(
                FormDefConfig.FORMDEF_KEY + moduleConfig.getPrefix(),
                testConfig);
        servletContext.setAttribute(
                Globals.MODULE_KEY + moduleConfig.getPrefix(),
                moduleConfig);

        action = new MockAction();
        actionServlet = new MockActionServlet();
        actionServlet.setServletContext(servletContext);
        action.setServlet(actionServlet);

        // Configure two resource bundles
        MessageResourcesConfig messageResourcesConfig =
                new MessageResourcesConfig();
        messageResourcesConfig.setParameter
                ("formdef.plugin.util.TestFormUtilsPopulateFormLocale");
        moduleConfig.addMessageResourcesConfig(messageResourcesConfig);

        messageResourcesConfig = new MessageResourcesConfig();
        messageResourcesConfig.setParameter
                ("formdef.plugin.util.TestFormUtilsPopulateFormLocale2");
        messageResourcesConfig.setKey("bundle2");
        moduleConfig.addMessageResourcesConfig(messageResourcesConfig);

        // Initialize the resource bundles
        try {
            actionServlet.initModuleMessageResources(moduleConfig);
        } catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Exception(
                    "Exception in TestActionRedirect.setupModuleConfig4(): "
                    + e.getMessage());
        }
        
        // configure a mapping we can use
        mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);

        // create out type sampler;  this object should *not* be modified by any of the tests
        sampleBean2a = new SampleBean2();
        sampleBean2a.setfString("1");
        sampleBean2a.setfInt(2);
        sampleBean2a.setfDouble(1234.5);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        java.util.Date date = sdf.parse("12/04/2004");
        sampleBean2a.setfDate(date);
    }


    
    // **********************************
    //    testPopulateFormXYZ methods

    /**
     * Make sure the default properties file gets used when no locale is given 
     */
    public void testPopulateFormDefaultLocale()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2a",
                        action, mapping, request);

        ModuleUtils.getInstance().selectModule("", request, servletContext);
        formUtils.populateForm("sampleBean2a",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1,234.50", form.get("fDouble"));
        assertEquals("Incorrect form value", "12/04/04", form.get("fDate"));
    }

    /**
     * Make sure the default properties file gets used when no locale matches 
     */
    public void testPopulateFormNoMatchLocale()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2a",
                        action, mapping, request);
        
        request.setLocale(new Locale("FR"));
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        
        formUtils.populateForm("sampleBean2a",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1,234.50", form.get("fDouble"));
        assertEquals("Incorrect form value", "12/04/04", form.get("fDate"));
    }

    /**
     * Make sure the correct properties file gets used  
     */
    public void testPopulateFormITLocale()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2a",
                        action, mapping, request);
        
        request.setLocale(new Locale("IT"));
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        
        formUtils.populateForm("sampleBean2a",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1.234,50", form.get("fDouble"));
        assertEquals("Incorrect form value", "04-12-04", form.get("fDate"));
    }

    /**
     * Make sure the correct properties file gets used  
     */
    public void testPopulateFormDELocale()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2a",
                        action, mapping, request);
        
        request.setLocale(new Locale("DE"));
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        
        formUtils.populateForm("sampleBean2a",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1.234,50", form.get("fDouble"));
        assertEquals("Incorrect form value", "04.12.04", form.get("fDate"));
    }

    /**
     * Make sure the default properties file gets used when no locale is given 
     */
    public void testPopulateFormDefaultLocaleBundle()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2b",
                        action, mapping, request);
        
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        formUtils.populateForm("sampleBean2b",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1234.50", form.get("fDouble"));
        assertEquals("Incorrect form value", "12/04/2004", form.get("fDate"));
    }

    /**
     * Make sure the default properties file gets used when no locale matches 
     */
    public void testPopulateFormNoMatchLocaleBundle()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2b",
                        action, mapping, request);
        
        request.setLocale(new Locale("FR"));
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        
        formUtils.populateForm("sampleBean2b",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1234.50", form.get("fDouble"));
        assertEquals("Incorrect form value", "12/04/2004", form.get("fDate"));
    }

    /**
     * Make sure the correct properties file gets used  
     */
    public void testPopulateFormITLocaleBundle()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2b",
                        action, mapping, request);
        
        request.setLocale(new Locale("IT"));
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        
        formUtils.populateForm("sampleBean2b",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1234,50", form.get("fDouble"));
        assertEquals("Incorrect form value", "04-12-2004", form.get("fDate"));
    }

    /**
     * Make sure the correct properties file gets used  
     */
    public void testPopulateFormDELocaleBundle()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2b",
                        action, mapping, request);
        
        request.setLocale(new Locale("DE"));
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        
        formUtils.populateForm("sampleBean2b",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1234,50", form.get("fDouble"));
        assertEquals("Incorrect form value", "04.12.2004", form.get("fDate"));
    }


    /**
     * Make sure we use the locale that's set in Struts.  
     */
    public void testPopulateFormUsingStrutsDELocale()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2b",
                        action, mapping, request);
        session.setAttribute(Globals.LOCALE_KEY, new Locale("DE"));
        
        request.setLocale(Locale.getDefault());
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        
        formUtils.populateForm("sampleBean2b",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1234,50", form.get("fDouble"));
        assertEquals("Incorrect form value", "04.12.2004", form.get("fDate"));
    }
    
    /**
     * Make sure we use the locale that's set in Struts.  
     */
    public void testPopulateFormUsingStrutsITLocale()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2b",
                        action, mapping, request);
        session.setAttribute(Globals.LOCALE_KEY, new Locale("IT"));
        
        request.setLocale(Locale.getDefault());
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        
        formUtils.populateForm("sampleBean2b",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1234,50", form.get("fDouble"));
        assertEquals("Incorrect form value", "04-12-2004", form.get("fDate"));
    }


    /**
     * Make sure we use the locale that's set in Struts.  
     */
    public void testPopulateFormUsingStrutsFRLocale()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm("sampleBean2b",
                        action, mapping, request);
        session.setAttribute(Globals.LOCALE_KEY, new Locale("FR"));
        
        request.setLocale(Locale.getDefault());
        ModuleUtils.getInstance().selectModule("", request, servletContext);
        
        formUtils.populateForm("sampleBean2b",
                form, sampleBean2a, moduleConfig, action, null, request);

        // check the form's values
        assertEquals("Incorrect form value", "1", form.get("fString"));
        assertEquals("Incorrect form value", "2", form.get("fInt"));
        assertEquals("Incorrect form value", "1234.50", form.get("fDouble"));
        assertEquals("Incorrect form value", "12/04/2004", form.get("fDate"));
    }


    //  end of testPopulateFormXYZ methods
    // **********************************

}
