package formdef.plugin.util;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.Action;
import org.apache.struts.mock.MockServletContext;
import org.apache.struts.mock.MockHttpServletRequest;
import org.apache.struts.mock.MockHttpSession;
import org.apache.struts.mock.MockActionServlet;
import org.apache.struts.mock.MockAction;
import org.apache.struts.Globals;

import formdef.plugin.sample.NestingBean1;
import formdef.plugin.sample.SampleBean1;
import formdef.plugin.sample.NestingBean2;
import formdef.plugin.sample.NestingBean3;
import formdef.plugin.digester.DefaultDigester;
import formdef.plugin.config.FormDefConfig;

import java.util.Locale;
import java.util.ArrayList;
import java.util.List;
import java.io.InputStream;
import java.io.BufferedInputStream;

/**
 * Tests the getFormValues() and setFormValues() method of FormUtils with
 * beans containing nested beans.
 */
public class TestFormUtilsPopulateFormNested extends TestCase {

    //*****************************
    // the usual suspects

    public TestFormUtilsPopulateFormNested(String s) {
        super(s);
    }

    public static TestSuite getSuite() {
        return new TestSuite(TestFormUtilsPopulateFormNested.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner runner = new junit.textui.TestRunner();
        runner.doRun(TestFormUtilsPopulateFormNested.getSuite());
    }



    //*****************************

    protected FormDefConfig formDefConfig = null;
    
    /** mock servlet objects */
    protected MockServletContext servletContext = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpSession session = null;
    protected Locale locale = null;
    
    /** empty module config */
    protected ModuleConfig moduleConfig = null;

    protected Action action = null;
    MockActionServlet actionServlet = null;
    protected ActionMapping mapping = null;
    
    // our test objects
    NestingBean1 nestingBean1 = null;
    NestingBean2 nestingBean2 = null;
    NestingBean3 nestingBean3 = null;
    DynaActionForm sampleForm1 = null;
    DynaActionForm nestingForm1 = null;
    DynaActionForm nestingForm2 = null;
    DynaActionForm nestingForm3 = null;

    public void setUp()
            throws Exception {
        super.setUp();

        String filename = "formdef/plugin/util/form-utils-nested.xml";
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream(filename);
        formDefConfig = new FormDefConfig();
        DefaultDigester.readConfiguration(formDefConfig, new BufferedInputStream(is));
        is.close();

        // prepare a module config
        moduleConfig = 
                ModuleConfigFactory.createFactory().createModuleConfig("");

        formDefConfig.registerForms(moduleConfig);

        // prepare the mock servlet objects
        servletContext = new MockServletContext();
        session = new MockHttpSession(servletContext);
        locale = Locale.getDefault();
        request = new MockHttpServletRequest(session);
        request.setLocale(locale);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        
        // store our config in the servlet context
        servletContext.setAttribute(
                FormDefConfig.FORMDEF_KEY + moduleConfig.getPrefix(),
                formDefConfig);
        servletContext.setAttribute(
                Globals.MODULE_KEY + moduleConfig.getPrefix(),
                moduleConfig);
        
        action = new MockAction();
        actionServlet = new MockActionServlet();
        actionServlet.setServletContext(servletContext);
        action.setServlet(actionServlet);

        // Configure a mapping we can use
        mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);

        // populate our nestingBean1
        nestingBean1 = new NestingBean1();
        nestingBean1.setLabel("NestingBean1");
        nestingBean1.setSampleBean1(new SampleBean1());
        
        nestingBean1.getSampleBean1().setfDouble(789.789);
        nestingBean1.getSampleBean1().setfInt(123);
        nestingBean1.getSampleBean1().setfString("Sample");

        // populate sampleForm1
        sampleForm1 = (DynaActionForm)
                FormUtils.getInstance().createActionForm("sampleForm1",
                        action, mapping, request);
        sampleForm1.set("fDouble", "789.789");
        sampleForm1.set("fInt", "123");
        sampleForm1.set("fString", "Sample");

        // populate nestingForm1
        nestingForm1 = (DynaActionForm) 
                FormUtils.getInstance().createActionForm("nestingForm1",
                        action, mapping, request);
        nestingForm1.set("label", "NestingBean1");
        nestingForm1.set("sampleBean1", sampleForm1);

        
        // populate nestingBean2
        nestingBean2 = new NestingBean2();
        nestingBean2.setLabel("NestingBean2");
        nestingBean2.setNestingBean1(nestingBean1);
        
        // populate nestingForm2
        nestingForm2 = (DynaActionForm)
                FormUtils.getInstance().createActionForm("nestingForm2",
                        action, mapping, request);
        nestingForm2.set("label", "NestingBean2");
        nestingForm2.set("nestingBean1", nestingForm1);

        
        // populate nestingBean3
        nestingBean3 = new NestingBean3();
        nestingBean3.setLabel("NestingBean3");
        nestingBean3.setNestingBean2(new ArrayList());
        nestingBean3.getNestingBean2().add(nestingBean2);
        
        // populate nestingForm3
        nestingForm3 = (DynaActionForm)
                FormUtils.getInstance().createActionForm("nestingForm3",
                        action, mapping, request);
        nestingForm3.set("label", "NestingBean3");
        ArrayList bean2s = new ArrayList();
        bean2s.add(nestingForm2);
        nestingForm3.set("nestingBean2", bean2s);
    }


    // **********************************
    //    test methods

    
    /**
     * Test a bean that nests a bean.
     */
    public void testSetFormValuesTwoLevelNesting()
            throws Exception {

        DynaActionForm form = (DynaActionForm)
                FormUtils.setFormValues("nestingForm1", nestingBean1,
                        action, mapping, request);

        // check the form's values
        assertEquals("Incorrect form value", "NestingBean1", form.get("label"));
        
        DynaActionForm sampleForm = (DynaActionForm) form.get("sampleBean1");
        assertNotNull("Null nesting bean", sampleForm);
        
        assertEquals("Incorrect form value", "789.789", sampleForm.get("fDouble"));
        assertEquals("Incorrect form value", "123", sampleForm.get("fInt"));
        assertEquals("Incorrect form value", "Sample", sampleForm.get("fString"));
    }

    
    /**
     * Test a form that nests a form.
     */
    public void testGetFormValuesTwoLevelNesting()
            throws Exception {

        mapping.setName("nestingForm1");
        NestingBean1 values = (NestingBean1)
                FormUtils.getFormValues(nestingForm1, 
                        action, mapping, request);

        // check the bean's values
        assertEquals("Incorrect bean value", "NestingBean1", values.getLabel());
        
        SampleBean1 sbValues = values.getSampleBean1();
        assertNotNull("Null nesting bean", sbValues);
        
        assertEquals("Incorrect bean value", 789.789, sbValues.getfDouble(), 0);
        assertEquals("Incorrect bean value", 123, sbValues.getfInt());
        assertEquals("Incorrect bean value", "Sample", sbValues.getfString());
    }

    
    /**
     * Test a bean that nests a bean that nests a bean.
     */
    public void testSetFormValuesThreeLevelNesting()
            throws Exception {

        DynaActionForm form = (DynaActionForm)
                FormUtils.setFormValues("nestingForm2", nestingBean2,
                        action, mapping, request);

        // check the form's values
        assertEquals("Incorrect form value", "NestingBean2", form.get("label"));
        
        DynaActionForm nestingForm1 = (DynaActionForm) form.get("nestingBean1");
        assertNotNull("Null nesting bean", nestingForm1);
        assertEquals("Incorrect form value", "NestingBean1", nestingForm1.get("label"));
        
        DynaActionForm sampleForm = (DynaActionForm) nestingForm1.get("sampleBean1");
        assertNotNull("Null nesting bean", sampleForm);
        
        assertEquals("Incorrect form value", "789.789", sampleForm.get("fDouble"));
        assertEquals("Incorrect form value", "123", sampleForm.get("fInt"));
        assertEquals("Incorrect form value", "Sample", sampleForm.get("fString"));
    }

    
    /**
     * Test a form that nests a form that nests a form.
     */
    public void testGetFormValuesThreeLevelNesting()
            throws Exception {

        mapping.setName("nestingForm2");
        NestingBean2 values = (NestingBean2)
                FormUtils.getFormValues(nestingForm2, 
                        action, mapping, request);

        // check the bean's values
        assertEquals("Incorrect bean value", "NestingBean2", values.getLabel());
        
        NestingBean1 nb1Values = values.getNestingBean1();
        assertEquals("Incorrect bean value", "NestingBean1", nb1Values.getLabel());
        
        SampleBean1 sbValues = nb1Values.getSampleBean1();
        assertNotNull("Null nesting bean", sbValues);
        
        assertEquals("Incorrect bean value", 789.789, sbValues.getfDouble(), 0);
        assertEquals("Incorrect bean value", 123, sbValues.getfInt());
        assertEquals("Incorrect bean value", "Sample", sbValues.getfString());
    }

    
    /**
     * Test a bean that nests a collection.
     */
    public void testSetFormValuesNestedCollection()
            throws Exception {
        
        // Add one more "nestingBean2" element to nestingBean3's collection
        NestingBean2 nb2 = new NestingBean2();
        nb2.setLabel("nb2");
        nb2.setNestingBean1(new NestingBean1());
        nb2.getNestingBean1().setLabel("nb2NestingBean1");
        nb2.getNestingBean1().setSampleBean1(new SampleBean1());
        nb2.getNestingBean1().getSampleBean1().setfDouble(123.678);
        nb2.getNestingBean1().getSampleBean1().setfInt(90);
        nb2.getNestingBean1().getSampleBean1().setfString("nb2SampleBean1");

        nestingBean3.getNestingBean2().add(nb2);

        // call the method we're testing
        DynaActionForm form = (DynaActionForm)
                FormUtils.setFormValues("nestingForm3", nestingBean3,
                        action, mapping, request);

        // check the form's values
        assertEquals("Incorrect form value", "NestingBean3", form.get("label"));
        
        ArrayList bean2s = (ArrayList) form.get("nestingBean2");
        
        assertEquals("Incorrect list size", 2, bean2s.size());
        
        // check the first element
        DynaActionForm nestingForm2 = (DynaActionForm) bean2s.get(0); 
        assertNotNull("Null nesting bean", nestingForm2);
        assertEquals("Incorrect form value", "NestingBean2", nestingForm2.get("label"));
        
        DynaActionForm nestingForm1 = (DynaActionForm) nestingForm2.get("nestingBean1");
        assertNotNull("Null nesting bean", nestingForm1);
        assertEquals("Incorrect form value", "NestingBean1", nestingForm1.get("label"));
        
        DynaActionForm sampleForm = (DynaActionForm) nestingForm1.get("sampleBean1");
        assertNotNull("Null nesting bean", sampleForm);
        
        assertEquals("Incorrect form value", "789.789", sampleForm.get("fDouble"));
        assertEquals("Incorrect form value", "123", sampleForm.get("fInt"));
        assertEquals("Incorrect form value", "Sample", sampleForm.get("fString"));
        
        
        // check the second element
        nestingForm2 = (DynaActionForm) bean2s.get(1); 
        assertNotNull("Null nesting bean", nestingForm2);
        assertEquals("Incorrect form value", "nb2", nestingForm2.get("label"));
        
        nestingForm1 = (DynaActionForm) nestingForm2.get("nestingBean1");
        assertNotNull("Null nesting bean", nestingForm1);
        assertEquals("Incorrect form value", "nb2NestingBean1", nestingForm1.get("label"));
        
        sampleForm = (DynaActionForm) nestingForm1.get("sampleBean1");
        assertNotNull("Null nesting bean", sampleForm);
        
        assertEquals("Incorrect form value", "123.678", sampleForm.get("fDouble"));
        assertEquals("Incorrect form value", "90", sampleForm.get("fInt"));
        assertEquals("Incorrect form value", "nb2SampleBean1", sampleForm.get("fString"));
        
        
        
    }

    
    /**
     * Test a form that nests a collection.
     */
    public void testGetFormValuesNestedCollection()
            throws Exception {
        // Add one more nestingForm2 to nestingForm3
        DynaActionForm sb1 = (DynaActionForm) FormUtils.getInstance().
                createActionForm("sampleForm1", action, mapping, request);
        sb1.set("fDouble", "123.678");
        sb1.set("fInt", "90");
        sb1.set("fString", "nf2SampleBean1");
        
        DynaActionForm nf1 = (DynaActionForm) FormUtils.getInstance().
                createActionForm("nestingForm1", action, mapping, request);
        nf1.set("label", "nf2NestingBean1");
        nf1.set("sampleBean1", sb1);
        
        DynaActionForm nf2 = (DynaActionForm) FormUtils.getInstance().
                createActionForm("nestingForm2", action, mapping, request);
        nf2.set("label", "nf2");
        nf2.set("nestingBean1", nf1);
        
        ((List) nestingForm3.get("nestingBean2")).add(nf2);

        mapping.setName("nestingForm3");
        NestingBean3 nestingBean3 = (NestingBean3)
                FormUtils.getFormValues(nestingForm3, 
                        action, mapping, request);

        // check the bean's values
        assertEquals("Incorrect bean value", "NestingBean3", nestingBean3.getLabel());
        
        List bean2s = nestingBean3.getNestingBean2();
        
        // check the list size
        assertEquals("Incorrect list size", 2, bean2s.size());
        
        // check the first nestingBean1
        NestingBean2 nestingBean2 = (NestingBean2) bean2s.get(0); 
        assertEquals("Incorrect bean value", "NestingBean2", nestingBean2.getLabel());
        
        NestingBean1 nestingBean1 = nestingBean2.getNestingBean1();
        assertEquals("Incorrect bean value", "NestingBean1", nestingBean1.getLabel());
        
        SampleBean1 sbValues = nestingBean1.getSampleBean1();
        assertNotNull("Null nesting bean", sbValues);
        
        assertEquals("Incorrect bean value", 789.789, sbValues.getfDouble(), 0);
        assertEquals("Incorrect bean value", 123, sbValues.getfInt());
        assertEquals("Incorrect bean value", "Sample", sbValues.getfString());

        // check the second nestingBean2
        nestingBean2 = (NestingBean2) bean2s.get(1); 
        assertEquals("Incorrect bean value", "nf2", nestingBean2.getLabel());
        
        nestingBean1 = nestingBean2.getNestingBean1();
        assertEquals("Incorrect bean value", "nf2NestingBean1", nestingBean1.getLabel());
        
        sbValues = nestingBean1.getSampleBean1();
        assertNotNull("Null nesting bean", sbValues);
        
        assertEquals("Incorrect bean value", 123.678, sbValues.getfDouble(), 0);
        assertEquals("Incorrect bean value", 90, sbValues.getfInt());
        assertEquals("Incorrect bean value", "nf2SampleBean1", sbValues.getfString());
    }

    
    //  end of test methods
    // **********************************

}
