/*
 * Decompiled with CFR 0.152.
 */
package formdef.plugin.config;

import formdef.plugin.FormMapping;
import formdef.plugin.config.FormMappingConfig;
import formdef.plugin.config.GlobalConverterConfig;
import formdef.plugin.config.PropertyMappingConfig;
import formdef.plugin.conversion.ConverterFactory;
import formdef.plugin.util.FormUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.FormPropertyConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.RequestUtils;

public class FormDefConfig {
    private static final Log log = LogFactory.getLog((Class)(class$formdef$plugin$config$FormDefConfig == null ? (class$formdef$plugin$config$FormDefConfig = FormDefConfig.class$("formdef.plugin.config.FormDefConfig")) : class$formdef$plugin$config$FormDefConfig));
    public static final String FORMDEF_KEY = "formdef.plugin.FormDefPlugIn";
    protected Map formDefForms = new HashMap();
    protected Map formDefFormConfigs = new HashMap();
    protected Map propertyTypeConverters = new LinkedHashMap();
    protected Map propertyNameConverters = new HashMap();
    protected Map converterNameConverters = new HashMap();
    protected Class formType = class$org$apache$struts$action$DynaActionForm == null ? (class$org$apache$struts$action$DynaActionForm = FormDefConfig.class$("org.apache.struts.action.DynaActionForm")) : class$org$apache$struts$action$DynaActionForm;
    static /* synthetic */ Class class$formdef$plugin$config$FormDefConfig;
    static /* synthetic */ Class class$org$apache$struts$action$DynaActionForm;
    static /* synthetic */ Class class$org$apache$struts$config$FormBeanConfig;
    static /* synthetic */ Class class$org$apache$commons$beanutils$DynaBean;
    static /* synthetic */ Class class$org$apache$struts$config$FormPropertyConfig;
    static /* synthetic */ Class class$java$lang$String;

    public void addForm(FormMappingConfig formConfig) throws Exception {
        this.formDefForms.put(formConfig.getName(), formConfig.generateForm(this));
        this.formDefFormConfigs.put(formConfig.getName(), formConfig);
    }

    public void addConverter(GlobalConverterConfig config) throws ClassNotFoundException {
        int forValue = config.getForValue();
        if (forValue == 0) {
            Class targetClass = FormUtils.getInstance().classForName(config.getTarget());
            config.setTargetClass(targetClass);
            this.propertyTypeConverters.put(config.getTarget(), config);
        } else if (forValue == 1) {
            this.propertyNameConverters.put(config.getTarget(), config);
        } else if (forValue == 2) {
            this.converterNameConverters.put(config.getTarget(), config);
        }
    }

    public void setFormType(String formTypeName) throws ClassNotFoundException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Using " + formTypeName + " as default form type."));
        }
        this.formType = Class.forName(formTypeName);
    }

    public void setFormUtilsFactory(String formUtilsFactory) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Using " + formUtilsFactory + " as FormUtils factory."));
        }
        FormUtils.setFactoryClassName(formUtilsFactory);
    }

    public void setConverterFactory(String converterFactory) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Using " + converterFactory + " as ConverterFactory."));
        }
        ConverterFactory.setConverterFactoryClassName(converterFactory);
    }

    public GlobalConverterConfig findPropertyTypeConverter(Class propertyType) {
        GlobalConverterConfig result = (GlobalConverterConfig)this.propertyTypeConverters.get(propertyType.getName());
        if (result == null) {
            Iterator iter = this.propertyTypeConverters.keySet().iterator();
            while (iter.hasNext()) {
                GlobalConverterConfig config = (GlobalConverterConfig)this.propertyTypeConverters.get(iter.next());
                if (config.isExactMatch() || config.getTargetClass() == null || !config.getTargetClass().isAssignableFrom(propertyType)) continue;
                return config;
            }
        }
        return result;
    }

    public GlobalConverterConfig findPropertyNameConverter(String propertyName) {
        return (GlobalConverterConfig)this.propertyNameConverters.get(propertyName);
    }

    public GlobalConverterConfig findConverterNameConverter(String converterName) {
        return (GlobalConverterConfig)this.converterNameConverters.get(converterName);
    }

    public String[] getFormNames() {
        ArrayList<String> names = new ArrayList<String>();
        Set keys = this.formDefForms.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            FormMapping form = (FormMapping)this.formDefForms.get(iter.next());
            names.add(form.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public FormMapping getForm(String name) {
        return (FormMapping)this.formDefForms.get(name);
    }

    public void registerForms(ModuleConfig moduleConfig) throws ClassNotFoundException {
        Set keys = this.formDefForms.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            FormMapping form = (FormMapping)this.formDefForms.get(iter.next());
            FormBeanConfig formBeanConfig = this.generateFormBeanConfig(form, moduleConfig);
            if (log.isTraceEnabled()) {
                log.trace((Object)("adding formBeanConfig: " + formBeanConfig));
            }
            moduleConfig.addFormBeanConfig(formBeanConfig);
            form.setFormBeanConfig(formBeanConfig);
        }
    }

    public FormBeanConfig generateFormBeanConfig(FormMapping form, ModuleConfig moduleConfig) throws ClassNotFoundException {
        Class<?> formBeanClass;
        FormMappingConfig formConfig = (FormMappingConfig)this.formDefFormConfigs.get(form.getName());
        String configType = formConfig.getConfigType();
        if (configType == null) {
            configType = (class$org$apache$struts$config$FormBeanConfig == null ? (class$org$apache$struts$config$FormBeanConfig = FormDefConfig.class$("org.apache.struts.config.FormBeanConfig")) : class$org$apache$struts$config$FormBeanConfig).getName();
        }
        FormBeanConfig formBeanConfig = (FormBeanConfig)this.instantiate(configType);
        formBeanConfig.setName(form.getName());
        String formBeanType = this.getFormType(form.getName());
        if (log.isTraceEnabled()) {
            log.trace((Object)(form.getName() + ": using " + formBeanType));
        }
        formBeanConfig.setType(formBeanType);
        Enumeration<Object> keys = formConfig.getConfigProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.setConfigPropertyByReflection(formBeanConfig, key, formConfig.getConfigProperties().getProperty(key));
        }
        if (formBeanType != null && !(class$org$apache$commons$beanutils$DynaBean == null ? (class$org$apache$commons$beanutils$DynaBean = FormDefConfig.class$("org.apache.commons.beanutils.DynaBean")) : class$org$apache$commons$beanutils$DynaBean).isAssignableFrom(formBeanClass = Class.forName(formBeanType))) {
            return formBeanConfig;
        }
        Iterator iter = form.getProperties().keySet().iterator();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            FormPropertyConfig propConfig = this.createFormPropertyConfig(propertyName, formConfig);
            formBeanConfig.addFormPropertyConfig(propConfig);
        }
        return formBeanConfig;
    }

    protected FormPropertyConfig createFormPropertyConfig(String propertyName, FormMappingConfig formConfig) {
        PropertyMappingConfig mappingConfig;
        String configType;
        if (log.isTraceEnabled()) {
            log.trace((Object)("property: [" + propertyName + "]"));
        }
        if ((configType = (mappingConfig = formConfig.getProperty(propertyName)).getConfigType()) == null) {
            configType = (class$org$apache$struts$config$FormPropertyConfig == null ? (class$org$apache$struts$config$FormPropertyConfig = FormDefConfig.class$("org.apache.struts.config.FormPropertyConfig")) : class$org$apache$struts$config$FormPropertyConfig).getName();
        }
        FormPropertyConfig propConfig = (FormPropertyConfig)this.instantiate(configType);
        propConfig.setName(propertyName);
        if (mappingConfig.getType() != null) {
            propConfig.setType(mappingConfig.getType());
        } else if (mappingConfig.getFormName() != null) {
            propConfig.setType(this.getFormType(mappingConfig.getFormName()));
        } else {
            propConfig.setType((class$java$lang$String == null ? (class$java$lang$String = FormDefConfig.class$("java.lang.String")) : class$java$lang$String).getName());
        }
        if (mappingConfig.getInitial() != null) {
            propConfig.setInitial(mappingConfig.getInitial());
        }
        if (mappingConfig.getSize() != null) {
            propConfig.setSize(Integer.parseInt(mappingConfig.getSize()));
        }
        if (mappingConfig.getReset() != null) {
            this.setByReflection(propConfig, "reset", mappingConfig.getReset());
        }
        Enumeration<Object> keys = mappingConfig.getConfigProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.setConfigPropertyByReflection(propConfig, key, mappingConfig.getConfigProperties().getProperty(key));
        }
        return propConfig;
    }

    private Object instantiate(String className) {
        Object instance;
        try {
            instance = RequestUtils.applicationInstance((String)className);
        }
        catch (Exception e) {
            String errorMessage = "Exception [" + e + "," + e.getMessage() + "] while " + "instantiating " + className;
            log.error((Object)errorMessage, (Throwable)e);
            throw new IllegalArgumentException(errorMessage);
        }
        return instance;
    }

    private boolean setByReflection(Object destination, String name, Object value) {
        try {
            BeanUtils.setProperty((Object)destination, (String)name, (Object)value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean setConfigPropertyByReflection(Object destination, String key, Object value) {
        try {
            MethodUtils.invokeExactMethod((Object)destination, (String)"setProperty", (Object[])new Object[]{key, value});
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String getFormType(String formName) {
        FormMappingConfig formConfig = (FormMappingConfig)this.formDefFormConfigs.get(formName);
        if (formConfig == null) {
            throw new IllegalArgumentException("Unable to locate " + formName + " among the forms registered with FormDef for " + "this module.");
        }
        String formBeanType = formConfig.getFormType();
        if (formBeanType == null) {
            formBeanType = this.formType.getName();
        }
        return formBeanType;
    }

    public void cleanup() {
        this.formDefFormConfigs = null;
        this.formType = null;
        Iterator iter = this.formDefForms.keySet().iterator();
        while (iter.hasNext()) {
            String formName = (String)iter.next();
            FormMapping form = (FormMapping)this.formDefForms.get(formName);
            if (form != null && form.getBeanType() != null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("removing " + form + " from FormDef list"));
            }
            iter.remove();
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("FormDefConfig [");
        result.append("formDefForms=[").append(this.formDefForms).append("];");
        result.append("]");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

