package formdef.plugin.example.sampler;

import org.apache.struts.action.*;
import org.apache.struts.validator.DynaValidatorForm;
import org.apache.struts.validator.DynaValidatorActionForm;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.Log;

import javax.servlet.http.*;

import formdef.plugin.util.FormUtils;

import java.text.SimpleDateFormat;

public class SamplerAction extends Action {

    private static final Log log = LogFactory.getLog(SamplerAction.class);

    public ActionForward execute(ActionMapping mapping,
                                 ActionForm form,
                                 HttpServletRequest request,
                                 HttpServletResponse response)
            throws Exception {

        TypeSampler sampler = null;
        if (form != null) {
            if (log.isDebugEnabled()) {
                log.debug("received form=" + form);
                if (form instanceof ActionForm) log.debug("ActionForm");
                if (form instanceof DynaActionForm) log.debug("DynaActionForm");
                if (form instanceof DynaValidatorForm) log.debug("DynaValidatorForm");
                if (form instanceof DynaValidatorActionForm) log.debug("DynaValidatorActionForm");
            }
            sampler = (TypeSampler) FormUtils.getFormValues(form,this,mapping,request);
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            sampler.setTimestamp1(new java.sql.Timestamp(sdf.parse((String)((DynaActionForm)form).get("timestamp1")).getTime()));
            log.info("received sampler=" + sampler);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            sampler = new TypeSampler();
            sampler.setInt1(1);
            sampler.setInt2(20002);
            sampler.setLong1(3);
            sampler.setDouble1(4);
            sampler.setDouble2(5);
            sampler.setFloat1(6);
            sampler.setByte1((byte)7);
            sampler.setShort1((short)8);
            sampler.setChar1('a');
            sampler.setString1("string1");
            sampler.setBoolean1(true);
            sampler.setDate1(sdf.parse("09/25/2003"));
            sampler.setDate2(sdf.parse("10/25/2003"));
            sampler.setDate3(sdf.parse("11/25/2003"));
            sampler.setDate4(sdf.parse("12/25/2003"));
            sampler.setTimestamp1(new java.sql.Timestamp(sdf.parse("01/25/2004").getTime()));
            sampler.setIntWrapper1(new Integer(13));
            sampler.setLongWrapper1(new Long(14));
            sampler.setDoubleWrapper1(new Double(15));
            sampler.setFloatWrapper1(new Float(16));
            sampler.setByteWrapper1(new Byte((byte)17));
            sampler.setShortWrapper1(new Short((short)18));
            sampler.setCharWrapper1(new Character('A'));
            sampler.setBooleanWrapper1(Boolean.TRUE);
            log.info("sending sampler=" + sampler);
        }

        request.getSession().setAttribute("samplerForm",
                FormUtils.setFormValues("samplerForm", sampler, this,mapping,request));
        return mapping.findForward("samplerForm");
    }

}
