package formdef.plugin;

import org.apache.struts.config.FormBeanConfig;

import java.util.Map;
import java.util.HashMap;
import java.lang.reflect.Method;

/**
 * Represents a form instance whose field definitions are based on an associated java class.
 * @author Hubert Rabago
 */
public class FormMapping {

    /** 
     * The given name of this form as it will be configured in Struts. 
     */
    private String name;
    
    /**
     * The Class of the java bean mapped to this form.
     */ 
    private Class beanType;
    
    /**
     * The factory used to create new instances of the bean in this mapping.
     */ 
    private Object factory;
    
    /**
     * The name of the factory's method used to create new instances of the
     * bean in this mapping.
     * @deprecated This is no longer used and will be removed in a future 
     * version.
     */ 
    private String factoryMethodName;
    
    /**
     * The Method object used to create new instances of the
     * bean in this mapping.
     */ 
    private Method factoryMethod;
    
    /**
     * "true" if this form's name will be passed as parameter to the factory
     * method.
     */ 
    private boolean factoryMethodNameParam;

    /** the {@link PropertyMapping} objects for this form */
    private Map properties;
    
    /**
     * The Struts configuration for the form associated with this mapping. 
     */ 
    private FormBeanConfig formBeanConfig;

    /**
     * Construct an instance with no fields specified
     */
    public FormMapping() {
        this.properties = new HashMap();
    }

    /**
     * Construct an instance specifying the basic details about a form
     * @param name the name of the form
     * @param beanType the Class instance of the class associated with this form
     */
    public FormMapping(String name, Class beanType) {
        this();
        this.name = name;
        this.beanType = beanType;
    }
    
    
    //*************************************************************************
    // Accessors
    

    ///**
    // * Specify the factory used to generate instances of the associated class
    // * @param factory the object used to generate instances of this class
    // * @param methodName the method in the factory object to be called
    // * @param methodNameParam true if the method to be called accepts a String parameter for the
    // *  name of this form
    // */
    //public void setFactory(Object factory,
    //                       String methodName,
    //                       boolean methodNameParam) {
    //    this.factory = factory;
    //    this.factoryMethodName = methodName;
    //    this.factoryMethodNameParam = methodNameParam;
    //}

    /**
     * Specify the factory method used to generate instances of the associated class
     * @param factory the object used to generate instances of this class
     * @param method the method in the factory object to be called
     * @param methodNameParam true if the method to be called accepts a String parameter for the
     *  name of this form
     */
    public void setFactoryMethod(Object factory,
                                 Method method,
                                 boolean methodNameParam) {
        this.factory = factory;
        this.factoryMethod = method;
        this.factoryMethodNameParam = methodNameParam;
    }

    /** 
     * The given name of this form as it will be configured in Struts. 
     */
    public String getName() {
        return name;
    }

    /**
     * The Class of the java bean mapped to this form.
     */
    public Class getBeanType() {
        return beanType;
    }

    /**
     * The factory used to create new instances of the bean in this mapping.
     */
    public Object getFactory() {
        return factory;
    }

    /**
     * The name of the factory's method used to create new instances of the
     * bean in this mapping. 
     * @deprecated This is no longer used and will be removed in a future 
     * version.
     */
    public String getFactoryMethodName() {
        return factoryMethodName;
    }

    /**
     * The Method object used to create new instances of the
     * bean in this mapping.
     */
    public Method getFactoryMethod() {
        return factoryMethod;
    }

    /**
     * "true" if this form's name will be passed as parameter to the factory
     * method.
     */
    public boolean isFactoryMethodNameParam() {
        return factoryMethodNameParam;
    }

    /**
     * Get the Map which holds the {@link PropertyMapping} instances for this form
     * @return the map of {@link PropertyMapping} objects
     */
    public Map getProperties() {
        return properties;
    }

    /**
     * The Struts configuration for the form associated with this mapping. 
     */
    public FormBeanConfig getFormBeanConfig() {
        return formBeanConfig;
    }

    /**
     * The Struts configuration for the form associated with this mapping. 
     */
    public void setFormBeanConfig(FormBeanConfig formBeanConfig) {
        this.formBeanConfig = formBeanConfig;
    }

    
    //*************************************************************************
    
    
    /**
     * Returns a String representation of this object for logging or
     * debugging purposes.
     */ 
    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("FormMapping [");
        result.append("name=").append(getName()).append(";");
        result.append("beanType=").append(getBeanType()).append(";");
        if (getFactory() != null) { 
            result.append("factory=").append(getFactory()).append(";");
        }
        if (getFactoryMethod() != null) {
            result.append("factoryMethod=").append(getFactoryMethod()).append(";");
        }
        if (isFactoryMethodNameParam()) {
            result.append("factoryMethodNameParam=").append(isFactoryMethodNameParam()).append(";");
        }
        java.util.Iterator iter = properties.values().iterator();
        while (iter.hasNext()) {
            PropertyMapping property = (PropertyMapping) iter.next();
            result.append("\n").append(property);
        }
        result.append("]");
        return result.toString();
    }

}
