package formdef.plugin.conversion;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.Action;

import javax.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Properties;

/**
 * Provides information about a conversion operation.
 */
public class ConversionContext implements java.io.Serializable {
    
    /** The source object containing the values being converted. */
    private Object source;
    
    /** The destination object holding the converted values. */
    private Object destination;
    
    /** The name of the property being converted. */
    private String propertyName;

    /** The value to be converted. */ 
    private Object value;
    
    /** The type desired for the result. */ 
    private Class type;
    
    /** A conversion parameter, if necessary. */
    private Object param;
    
    /** The locale to use in conversion. */
    private Locale locale;
    
    /** The action executing the conversion. */
    private Action action;
    
    /** The mapping used for the action. */
    private ActionMapping mapping;
    
    /** The request being processed. */
    private HttpServletRequest request;

    /** The arbitrary properties configured for the conversion. */
    protected Properties properties;

    /**
     * Create a conversion context for converting the given value to 
     * the specified type.
     * @param value the value to convert
     * @param type the type desired for the result
     */ 
    public ConversionContext(Object value, Class type) {
        this.value = value;
        this.type = type;
    }

    /**
     * Return the source object containing the values being converted. 
     */ 
    public Object getSource() {
        return source;
    }

    /**
     * Set the source object containing the values being converted. 
     */ 
    public void setSource(Object source) {
        this.source = source;
    }

    /**
     * Return the destination object holding the converted values. 
     */ 
    public Object getDestination() {
        return destination;
    }

    /**
     * Set the destination object holding the converted values. 
     */ 
    public void setDestination(Object destination) {
        this.destination = destination;
    }

    /**
     * Return the name of the property being converted. 
     */ 
    public String getPropertyName() {
        return propertyName;
    }

    /**
     * Set the name of the property being converted. 
     */ 
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    /** 
     * Get the value to be converted to the specified {@link #type}
     * @return the value to be converted
     */ 
    public Object getValue() {
        return value;
    }

    /**
     * Get the Class that the given {@link #value} should be converted to
     * @return the desired type to convert to 
     */ 
    public Class getType() {
        return type;
    }

    /**
     * Get the parameter to be used in the conversion
     * @return a conversion-specific parameter
     */ 
    public Object getParam() {
        return param;
    }

    /**
     * Sets a conversion-specific parameter to be used during conversion
     * @param param a conversion-specific parameter
     */ 
    public void setParam(Object param) {
        this.param = param;
    }

    /**
     * Get the locale to use for conversion
     * @return a {@link Locale} providing information about the locale 
     * under which conversion is being done
     */ 
    public Locale getLocale() {
        return locale;
    }

    /**
     * Set the locale to use for conversion
     * @param locale the {@link Locale} to use in conversion
     */ 
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    /**
     * Return the action executing the conversion.
     */ 
    public Action getAction() {
        return action;
    }
    
    /**
     * Set the action executing the conversion.
     */ 
    public void setAction(Action action) {
        this.action = action;
    }

    /**
     * Return the mapping used for the action. 
     */ 
    public ActionMapping getMapping() {
        return mapping;
    }

    /**
     * Set the mapping used for the action. 
     */ 
    public void setMapping(ActionMapping mapping) {
        this.mapping = mapping;
    }

    /**
     * Return the request being processed. 
     */ 
    public HttpServletRequest getRequest() {
        return request;
    }

    /**
     * Set the request being processed. 
     */ 
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    /**
     * <p>Get an arbitrary property configured for the conversion, or null if
     * no such property is found.</p>
     * 
     * @deprecated  use {@link #getProperty(String)} instead.
     */ 
    public String getProperties(String name) {
        if (properties != null) {
            return properties.getProperty(name);
        }
        return null;
    }

    /**
     * <p>Get an arbitrary property configured for the conversion, or null if
     * no such property is found.</p>
     * 
     * @param key   the key of the property to retrieve.
     * 
     * @return the value in this property list with the specified key value.
     */ 
    public String getProperty(String key) {
        if (properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    /**
     * <p>Set an arbitrary property configured for the conversion.</p>
     * 
     * @param key       the key to be placed into this property list.
     * @param value     the value corresponding to key.
     * 
     * @return the previous value of the specified key in this property list, 
     *      or null if it did not have one.
     */ 
    public Object setProperty(String key, String value) {
        if (properties == null) {
            properties = new Properties();
        }
        
        return properties.setProperty(key, value);
    }
    
    /**
     * Set the arbitrary properties configured for the conversion.
     */ 
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
    

    /**
     * Returns a string representation of the object. 
     * @return  a string representation of the object.
     */
    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("ConversionContext [");
        result.append("propertyName=").append(getPropertyName()).append(";");
        result.append("value=").append(getValue()).append(";");
        result.append("type=").append(getType()).append(";");
        result.append("param=").append(getParam()).append(";");
        result.append("source=").append(getSource()).append(";");
        result.append("destination=").append(getDestination()).append(";");
        result.append("locale=").append(getLocale()).append(";");
        result.append("action=").append(getAction()).append(";");
        result.append("mapping=").append(getMapping()).append(";");
        result.append("request=").append(getRequest()).append(";");
        result.append("]");
        return result.toString();
    }


}
