package formdef.plugin.conversion;

/**
 * {@link Converter} implementation for Strings.
 */
public class StringConverter implements Converter {

    /**
     * <p>Simply returns the given value.</p>
     * 
     * @param context the {@link ConversionContext} holding information
     * about the value to convert and additional conversion parameters
     * @return the given value
     */
    public Object convert(ConversionContext context) {
        Object value = context.getValue();

        if (value == null) {
            return null;
        } else {
            return (value.toString());
        }
    }

}
