package formdef.plugin.config;

import junit.framework.TestCase;

import java.io.InputStream;
import java.io.BufferedInputStream;

import formdef.plugin.digester.DefaultDigester;
import formdef.plugin.sample.CustomFormBeanConfig;
import formdef.plugin.sample.CustomFormPropertyConfig;
import formdef.plugin.sample.FormBeanConfigWithProperty;
import formdef.plugin.sample.FormPropertyConfigWithProperty;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.FormPropertyConfig;

/**
 * 
 */
public class TestFormMappingConfig 
        extends TestCase {
    
    FormDefConfig testConfig;
    ModuleConfig moduleConfig;
    
    public void setUp()
            throws Exception {
        super.setUp();

        String filename = "formdef/plugin/config/formmappingconfig.xml";
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream(filename);

        testConfig = new FormDefConfig();
        DefaultDigester.readConfiguration(testConfig, new BufferedInputStream(is));
        is.close();

        // prepare a module config
        moduleConfig = 
                ModuleConfigFactory.createFactory().createModuleConfig("");

        testConfig.registerForms(moduleConfig);
    }
    
    
    //*************************************************************************
    // Tests for "configType" for both <form> and <field>
    
    /**
     * Test the form's configType.
     */ 
    public void testFormConfigType() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA0");

        assertTrue("Wrong class instantiated",
                fbc instanceof CustomFormBeanConfig);
    }

    /**
     * Test the field's configType.
     */ 
    public void testFieldConfigType() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA0");

        FormPropertyConfig fpc = fbc.findFormPropertyConfig("string1");
        assertFalse("Wrong class instantiated",
                fpc instanceof CustomFormPropertyConfig);

        fpc = fbc.findFormPropertyConfig("int1");
        assertTrue("Wrong class instantiated",
                fpc instanceof CustomFormPropertyConfig);

        fpc = fbc.findFormPropertyConfig("sampleBean1s");
        assertFalse("Wrong class instantiated",
                fpc instanceof CustomFormPropertyConfig);
    }
    

    //*************************************************************************
    // Tests for "set-property" for both <form> and <field>
    
    /**
     * Test the form's "set-property".
     */ 
    public void testFormSetProperty() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA1");

        assertTrue("Wrong class instantiated",
                fbc instanceof FormBeanConfigWithProperty);
        
        FormBeanConfigWithProperty fbcwp = (FormBeanConfigWithProperty) fbc;
        assertEquals("Missing or incorrect arbitrary property",
                "formpropvalue1", fbcwp.getProperty("formpropkey1"));
        assertEquals("Missing or incorrect arbitrary property",
                "formpropvalue2", fbcwp.getProperty("formpropkey2"));
    }

    /**
     * Test the field's "set-property".
     */ 
    public void testFieldSetProperty() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA1");

        FormPropertyConfig fpc = fbc.findFormPropertyConfig("int1");
        assertTrue("Wrong class instantiated",
                fpc instanceof FormPropertyConfigWithProperty);
        
        FormPropertyConfigWithProperty fpcwp = (FormPropertyConfigWithProperty) fpc;
        assertEquals("Missing or incorrect arbitrary property",
                "int1value1", fpcwp.getProperty("int1prop1"));
        assertEquals("Missing or incorrect arbitrary property",
                "int1value2", fpcwp.getProperty("int1prop2"));
    }

}
