package formdef.plugin.config;

import junit.framework.TestCase;

import java.io.InputStream;
import java.io.BufferedInputStream;

import formdef.plugin.digester.DefaultDigester;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.FormBeanConfig;

/**
 * 
 */
public class TestFormMappingConfigExcludes 
        extends TestCase {
    
    FormDefConfig testConfig;
    ModuleConfig moduleConfig;
    
    public void setUp()
            throws Exception {
        super.setUp();

        String filename = "formdef/plugin/config/formmappingconfig-excludes.xml";
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream(filename);

        testConfig = new FormDefConfig();
        DefaultDigester.readConfiguration(testConfig, new BufferedInputStream(is));
        is.close();

        // prepare a module config
        moduleConfig = 
                ModuleConfigFactory.createFactory().createModuleConfig("");

        testConfig.registerForms(moduleConfig);
    }
    
    
    /**
     * Test excludes element with one property.
     */ 
    public void testExcludesOneItem() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA0");
        
        assertNotNull("Property should be present", fbc.findFormPropertyConfig("string1"));
        assertNull("Property should not be here", fbc.findFormPropertyConfig("int1"));
        assertNotNull("Property should be present", fbc.findFormPropertyConfig("sampleBean1s"));
    }

    /**
     * Test excludes element with multiple properties.
     */ 
    public void testExcludesMultipleItems() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA1");
        
        assertNotNull("Property should be present", fbc.findFormPropertyConfig("string1"));
        assertNull("Property should not be here", fbc.findFormPropertyConfig("int1"));
        assertNull("Property should not be here", fbc.findFormPropertyConfig("sampleBean1s"));
    }

    /**
     * Test excludes element with varying whitespace.
     */ 
    public void testExcludesWhitespace() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA2");
        
        assertNull("Property should not be here", fbc.findFormPropertyConfig("string1"));
        assertNull("Property should not be here", fbc.findFormPropertyConfig("int1"));
        assertNotNull("Property should be present", fbc.findFormPropertyConfig("sampleBean1s"));
    }

    /**
     * Test excludes element spread across multiple lines.
     */ 
    public void testExcludesMultipleLines() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA3");
        
        assertNull("Property should not be here", fbc.findFormPropertyConfig("string1"));
        assertNotNull("Property should be present", fbc.findFormPropertyConfig("int1"));
        assertNull("Property should not be here", fbc.findFormPropertyConfig("sampleBean1s"));
    }

    /**
     * Test excludes element spread across multiple lines with some slight
     * variations.
     */ 
    public void testExcludesMultipleLinesAgain() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA4");
        
        assertNull("Property should not be here", fbc.findFormPropertyConfig("string1"));
        assertNotNull("Property should be present", fbc.findFormPropertyConfig("int1"));
        assertNull("Property should not be here", fbc.findFormPropertyConfig("sampleBean1s"));
    }

    /**
     * Test excluded fields configured through properties.
     */ 
    public void testExcludesThroughPropertyMappingConfig() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA5");
        
        assertNotNull("Property should be present", fbc.findFormPropertyConfig("string1"));
        assertNull("Property should not be here", fbc.findFormPropertyConfig("int1"));
        assertNull("Property should not be here", fbc.findFormPropertyConfig("sampleBean1s"));
    }

    /**
     * Test excluded fields configured both through properties and
     * the excludes form element.
     */ 
    public void testExcludesMixedConfig() {
        FormBeanConfig fbc = 
                moduleConfig.findFormBeanConfig("sampleIndexedBeanA6");
        
        assertNull("Property should not be here", fbc.findFormPropertyConfig("string1"));
        assertNotNull("Property should be present", fbc.findFormPropertyConfig("int1"));
        assertNull("Property should not be here", fbc.findFormPropertyConfig("sampleBean1s"));
    }
}
