package formdef.plugin.config;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.FormPropertyConfig;
import org.apache.struts.mock.MockServletContext;
import org.apache.struts.mock.MockHttpServletRequest;
import org.apache.struts.mock.MockHttpSession;

import formdef.plugin.sample.SampleIndexedBeanA;
import formdef.plugin.FormMapping;
import formdef.plugin.PropertyMapping;
import formdef.plugin.conversion.NumberConverter;

import java.util.Locale;

/**
 * Various tests for the PropertyMappingConfig class.
 */
public class TestPropertyMappingConfig extends TestCase {
    
    //*****************************
    // the usual suspects

    public TestPropertyMappingConfig(String s) {
        super(s);
    }

    public static TestSuite getSuite() {
        return new TestSuite(TestPropertyMappingConfig.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner runner = new junit.textui.TestRunner();
        runner.doRun(TestPropertyMappingConfig.getSuite());
    }
    
    //*****************************

    protected FormMappingConfig formMappingConfig = null;
    protected FormDefConfig testConfig = null;
    
    /** mock servlet objects */
    protected MockServletContext servletContext = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpSession session = null;
    protected Locale locale = null;
    
    /** empty module config */
    protected ModuleConfig moduleConfig = null;


    public void setUp()
            throws Exception {
        super.setUp();
    }
    
    /**
     * Test that we get the correct converter for an int field.
     */ 
    public void testGeneratePropertyInt()
            throws Exception {
        
        FormMapping form = 
                new FormMapping("sampleIndexedBeanA1", SampleIndexedBeanA.class);
        
        // create the object we'll be testing
        PropertyMappingConfig propConfig = new PropertyMappingConfig();
        propConfig.setName("int1");
        propConfig.setGetter("getInt1");
        propConfig.setSetter("setInt1");
        
        PropertyMapping result = propConfig.generateProperty(form, testConfig);
        
        assertNotNull("Results can't be null", result);
        assertTrue("Invalid converter", 
                result.getConverter() instanceof NumberConverter);
        
        assertEquals("Wrong property name", "int1", result.getName());
        assertNull("Invalid conversion parameter", result.getConversionParam());
        assertEquals("Type must be int", Integer.TYPE, result.getType());
        assertEquals("FormFieldType must be String", String.class, result.getFormFieldType());
    }
    
    /**
     * Check that we handle array properties correctly:<br/>
     *  <ul><li>We don't get a null result</li>
     *      <li>The type on the resulting mapping is correct</li>
     *      <li>We don't assign a converter</li>
     *  </ul>
     */ 
    public void testGeneratePropertyArray()
            throws Exception {
        
        FormMapping form = 
                new FormMapping("sampleIndexedBeanA1", SampleIndexedBeanA.class);
        
        // create the object we'll be testing
        PropertyMappingConfig propConfig = new PropertyMappingConfig();
        propConfig.setName("sampleBean1s");
        propConfig.setGetter("getSampleBean1s");
        propConfig.setSetter("setSampleBean1s");
        propConfig.setType("formdef.plugin.sample.SampleBean1[]");
        
        PropertyMapping result = propConfig.generateProperty(form, testConfig);
        
        assertNotNull("Results can't be null", result);
        assertEquals("Wrong property name", "sampleBean1s", result.getName());
        assertNull("Invalid conversion parameter", result.getConversionParam());
        assertNull("Converter must be null", result.getConverter());

        FormPropertyConfig formPropertyConfig = new FormPropertyConfig();
        formPropertyConfig.setType(propConfig.getType());
        assertEquals("Types do not match",
                formPropertyConfig.getTypeClass(), result.getType());
        assertEquals("FormFieldType in incorrect",
                formPropertyConfig.getTypeClass(), result.getFormFieldType());
    }
    
}
