package formdef.plugin.sample;

import java.util.Locale;

import formdef.plugin.conversion.Converter;
import formdef.plugin.conversion.ConversionContext;

/**
 * Converts data between Sex and String types.
 */
public class SexConverter implements Converter {

    /**
     * <p>Converts the value to the specified type.</p>
     * 
     * @param context the {@link formdef.plugin.conversion.ConversionContext} holding information
     * about the value to convert and additional conversion parameters
     * @return the equivalent of the given value, in the specified type
     */
    public Object convert(ConversionContext context) {
        Object value = context.getValue();
        Class type = context.getType();
        Object param = context.getParam();
        Locale locale = context.getLocale();
        if (type.equals(Sex.class)) {
            // the output should be of type Sex
            if ("F".equalsIgnoreCase((String)value)) {
                return Sex.FEMALE;
            } else {
                return Sex.MALE;
            }
        } else if (type.equals(String.class)) {
            // the output should be a String
            if (Sex.FEMALE == value) {
                return "F";
            } else {
                return "M";
            }
        } else {
            throw new IllegalArgumentException("Unsupported type parameter: " + type);
        }
    }

}
