package formdef.plugin.sample;

import formdef.plugin.conversion.DateConverter;
import formdef.plugin.conversion.ConversionContext;

import java.util.Locale;
import java.text.SimpleDateFormat;
import java.text.ParseException;

/**
 * Handle conversion from String to SubSqlDate; for other conversion types,
 * use the super class DateConverter.
 */
public class SubSqlDateConverter extends DateConverter {

    /**
     * <p>Converts the value to the specified type.</p>
     * 
     * @param context the {@link formdef.plugin.conversion.ConversionContext} holding information
     * about the value to convert and additional conversion parameters
     * @return the equivalent of the given value, in the specified type
     */
    public Object convert(ConversionContext context) {
        Object value = context.getValue();
        Class type = context.getType();
        Object param = context.getParam();
        Locale locale = context.getLocale();

        // is the caller looking for a SubSqlDate?
        if (type.equals(SubSqlDate.class)) {
            // create our formatter object
            SimpleDateFormat sdf = new SimpleDateFormat((String) param, locale);
            
            // create a date instance and set its value
            SubSqlDate date = null;
            try {
                date = new SubSqlDate();
                date.setTime(sdf.parse((String) value).getTime());
            } catch (ParseException e) {
                return null;
            }
            return date;
        } else {
            return super.convert(context);
        }
    }

}
