package formdef.plugin.util;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.Action;
import org.apache.struts.mock.MockServletContext;
import org.apache.struts.mock.MockHttpServletRequest;
import org.apache.struts.mock.MockHttpSession;
import org.apache.struts.mock.MockActionServlet;
import org.apache.struts.mock.MockAction;
import org.apache.struts.Globals;

import formdef.plugin.config.*;
import formdef.plugin.sample.TypeSampler;
import formdef.plugin.sample.MultiSampleBeanA;
import formdef.plugin.sample.Sex;
import formdef.plugin.digester.DefaultDigester;

import java.util.Locale;
import java.text.SimpleDateFormat;
import java.io.InputStream;
import java.io.BufferedInputStream;

/**
 * Tests the getFormValuesImpl() method of FormUtils.
 */
public class TestFormUtilsGetFormValues extends TestCase {

    //*****************************
    // the usual suspects

    public TestFormUtilsGetFormValues(String s) {
        super(s);
    }

    public static TestSuite getSuite() {
        return new TestSuite(TestFormUtilsGetFormValues.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner runner = new junit.textui.TestRunner();
        runner.doRun(TestFormUtilsGetFormValues.getSuite());
    }



    //*****************************

    protected GlobalConverterConfig mdyConverter = null;

    TypeSampler typeSampler1 = null;
    protected FormMappingConfig typeSampler1FormConfig = null;
    protected FormMappingConfig typeSampler2FormConfig = null;
    
    /** the form we'll be getting values from for a TypeSampler object */
    protected DynaActionForm typeSamplerForm1 = null;

    /** the form we'll be getting values from for a MultiSampleBeanA object */
    protected DynaActionForm multiSampleAForm1 = null;
   
    /** the instance used for tests that do not change the configuration */
    protected FormDefConfig testConfig = null;
    
    /** mock servlet objects */
    protected MockServletContext servletContext = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpSession session = null;
    protected Locale locale = null;
    
    /** empty module config */
    protected ModuleConfig moduleConfig = null;

    protected Action action = null;
    MockActionServlet actionServlet = null;
    protected ActionMapping mapping = null;
    
    public void setUp()
            throws Exception {
        super.setUp();

        String filename = "formdef/plugin/util/form-utils-getformvalues.xml";
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream(filename);

        testConfig = new FormDefConfig();
        DefaultDigester.readConfiguration(testConfig, new BufferedInputStream(is));
        is.close();

        // prepare a module config
        moduleConfig = 
                ModuleConfigFactory.createFactory().createModuleConfig("");

        testConfig.registerForms(moduleConfig);

        // prepare the mock servlet objects
        servletContext = new MockServletContext();
        session = new MockHttpSession(servletContext);
        locale = Locale.getDefault();
        request = new MockHttpServletRequest(session);
        request.setLocale(locale);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        
        // store our config in the servlet context
        servletContext.setAttribute(
                FormDefConfig.FORMDEF_KEY + moduleConfig.getPrefix(),
                testConfig);
        servletContext.setAttribute(
                Globals.MODULE_KEY + moduleConfig.getPrefix(),
                moduleConfig);

        action = new MockAction();
        actionServlet = new MockActionServlet();
        actionServlet.setServletContext(servletContext);
        action.setServlet(actionServlet);

        // Configure a mapping we can use 
        mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);

        // create our type sampler
        typeSampler1 = new TypeSampler();
        typeSampler1.setInt1(1);
        typeSampler1.setLong1(2);
        typeSampler1.setDouble1(3);
        typeSampler1.setFloat1(4);
        typeSampler1.setByte1((byte) 5);
        typeSampler1.setShort1((short) 6);
        typeSampler1.setChar1('7');
        typeSampler1.setString1("8");
        typeSampler1.setBoolean1(false);
        typeSampler1.setBoolean2(false);
        typeSampler1.setBoolean3(true);
        typeSampler1.setBoolean4(true);

        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        java.util.Date date = sdf.parse("12/01/2004");
        typeSampler1.setDate1(date);

        typeSampler1.setIntWrapper1(new Integer(11));
        typeSampler1.setLongWrapper1(new Long(12));
        typeSampler1.setDoubleWrapper1(new Double(13));
        typeSampler1.setFloatWrapper1(new Float(14));
        typeSampler1.setByteWrapper1(new Byte((byte) 15));
        typeSampler1.setShortWrapper1(new Short((short) 16));
        typeSampler1.setCharWrapper1(new Character('7'));
        typeSampler1.setBooleanWrapper1(new Boolean(false));
        typeSampler1.setBooleanWrapper2(new Boolean(false));

        // initialize a dynaForm for TypeSampler
        typeSamplerForm1 = (DynaActionForm)
                new FormUtils().createActionForm("typeSampler1",
                        action, mapping, request);
        
        typeSamplerForm1.set("int1","1");
        typeSamplerForm1.set("long1","2");
        typeSamplerForm1.set("double1","3.0");
        typeSamplerForm1.set("float1","4.0");
        typeSamplerForm1.set("byte1","5");
        typeSamplerForm1.set("short1","6");
        typeSamplerForm1.set("char1","7");
        typeSamplerForm1.set("string1","8");
        typeSamplerForm1.set("boolean1","false");
        typeSamplerForm1.set("boolean2","on");
        typeSamplerForm1.set("boolean3","yes");
        typeSamplerForm1.set("boolean4","1");
        typeSamplerForm1.set("date1","12/01/2004");
        typeSamplerForm1.set("intWrapper1","11");
        typeSamplerForm1.set("longWrapper1","12");
        typeSamplerForm1.set("doubleWrapper1","13.0");
        typeSamplerForm1.set("floatWrapper1","14.0");
        typeSamplerForm1.set("byteWrapper1","15");
        typeSamplerForm1.set("shortWrapper1","16");
        typeSamplerForm1.set("charWrapper1","7");
        typeSamplerForm1.set("booleanWrapper1","false");
        typeSamplerForm1.set("booleanWrapper2","on");
    }

    
    // **********************************
    //    testGetFormValuesXYZ methods

    /**
     * Basic test of all the primitive types (and their wrappers)
     */
    public void testGetFormValuesTypeSampler()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        ActionMapping mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        mapping.setName("typeSampler1");

        Object object = formUtils.getFormValuesImpl(
                typeSamplerForm1, action, mapping, request);

        assertNotNull("Null object returned", object);
        assertTrue("Invalid object type returned", 
                object instanceof TypeSampler);
        
        TypeSampler bean = (TypeSampler) object;
        
        // check the typeSamplerForm1's values
        assertEquals("Incorrect bean value", 1, bean.getInt1());
        assertEquals("Incorrect bean value", 2, bean.getLong1());
        assertEquals("Incorrect bean value", 3.0, bean.getDouble1(), 0);
        assertEquals("Incorrect bean value", (float) 4, bean.getFloat1(), 0);
        assertEquals("Incorrect bean value", (byte) 5, bean.getByte1());
        assertEquals("Incorrect bean value", (short) 6, bean.getShort1());
        assertEquals("Incorrect bean value", '7', bean.getChar1());
        assertEquals("Incorrect bean value", "8", bean.getString1());
        assertEquals("Incorrect bean value", false, bean.isBoolean1());
        assertEquals("Incorrect bean value", true, bean.isBoolean2());
        assertEquals("Incorrect bean value", true, bean.isBoolean3());
        assertEquals("Incorrect bean value", true, bean.isBoolean4());
        assertEquals("Incorrect bean value", "20041201", 
                new SimpleDateFormat("yyyyMMdd").format(bean.getDate1()));
        assertEquals("Incorrect bean value", 11, bean.getIntWrapper1().intValue());
        assertEquals("Incorrect bean value", 12, bean.getLongWrapper1().longValue());
        assertEquals("Incorrect bean value", 13, bean.getDoubleWrapper1().doubleValue(), 0);
        assertEquals("Incorrect bean value", (float) 14, bean.getFloatWrapper1().floatValue(), 0);
        assertEquals("Incorrect bean value", (byte) 15, bean.getByteWrapper1().byteValue());
        assertEquals("Incorrect bean value", (short) 16, bean.getShortWrapper1().shortValue());
        assertEquals("Incorrect bean value", '7', bean.getCharWrapper1().charValue());
        assertEquals("Incorrect bean value", Boolean.FALSE, bean.getBooleanWrapper1());
        assertEquals("Incorrect bean value", Boolean.TRUE, bean.getBooleanWrapper2());
    }

    /**
     * Basic test of all the primitive types (and their wrappers), calling
     * the method that accepts the object to populate.
     */
    public void testGetFormValuesTypeSamplerProvided()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        ActionMapping mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        mapping.setName("typeSampler1");

        TypeSampler bean = new TypeSampler();
        formUtils.getFormValuesImpl(typeSamplerForm1, bean,
                action, mapping, request);

        // check the typeSamplerForm1's values
        assertEquals("Incorrect bean value", 1, bean.getInt1());
        assertEquals("Incorrect bean value", 2, bean.getLong1());
        assertEquals("Incorrect bean value", 3.0, bean.getDouble1(), 0);
        assertEquals("Incorrect bean value", (float) 4, bean.getFloat1(), 0);
        assertEquals("Incorrect bean value", (byte) 5, bean.getByte1());
        assertEquals("Incorrect bean value", (short) 6, bean.getShort1());
        assertEquals("Incorrect bean value", '7', bean.getChar1());
        assertEquals("Incorrect bean value", "8", bean.getString1());
        assertEquals("Incorrect bean value", false, bean.isBoolean1());
        assertEquals("Incorrect bean value", true, bean.isBoolean2());
        assertEquals("Incorrect bean value", true, bean.isBoolean3());
        assertEquals("Incorrect bean value", true, bean.isBoolean4());
        assertEquals("Incorrect bean value", "20041201", 
                new SimpleDateFormat("yyyyMMdd").format(bean.getDate1()));
        assertEquals("Incorrect bean value", 11, bean.getIntWrapper1().intValue());
        assertEquals("Incorrect bean value", 12, bean.getLongWrapper1().longValue());
        assertEquals("Incorrect bean value", 13, bean.getDoubleWrapper1().doubleValue(), 0);
        assertEquals("Incorrect bean value", (float) 14, bean.getFloatWrapper1().floatValue(), 0);
        assertEquals("Incorrect bean value", (byte) 15, bean.getByteWrapper1().byteValue());
        assertEquals("Incorrect bean value", (short) 16, bean.getShortWrapper1().shortValue());
        assertEquals("Incorrect bean value", '7', bean.getCharWrapper1().charValue());
        assertEquals("Incorrect bean value", Boolean.FALSE, bean.getBooleanWrapper1());
        assertEquals("Incorrect bean value", Boolean.TRUE, bean.getBooleanWrapper2());
    }
    
    
    /**
     * Test getFormValues with an invalid destination object.
     */
    public void testGetFormValuesInvalidDestObject()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        ActionMapping mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        mapping.setName("typeSampler1");

        Object object = new Object();
        try {
            formUtils.getFormValuesImpl(typeSamplerForm1, object,
                    action, mapping, request);
            fail("Exception should've been thrown with incompatible dest object");
        } catch (IllegalArgumentException e) {
            // test passes
        }
    }

    /**
     * Test getFormValues when fields have conversion params
     */
    public void testGetFormValuesFormattedField()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        
        typeSamplerForm1.set("date1","20041203");
        typeSamplerForm1.set("double1","1,234,567.8000");
        
        ActionMapping mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        mapping.setName("typeSampler2");

        Object object = formUtils.getFormValuesImpl(
                typeSamplerForm1, action, mapping, request);

        assertNotNull("Null object returned", object);
        assertTrue("Invalid object type returned", 
                object instanceof TypeSampler);
        
        TypeSampler bean = (TypeSampler) object;
        
        // check the typeSamplerForm1's values
        assertEquals("Incorrect bean value", 1234567.8, bean.getDouble1(), 0);
        assertEquals("Incorrect bean value", "20041203", 
                new SimpleDateFormat("yyyyMMdd").format(bean.getDate1()));
    }

    /**
     * See if fields with no converters are skipped as expected
     */
    public void testGetFormValuesNullConverter()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        String formName = "multiSampleBeanA1";
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm(formName,
                        action, mapping, request);
        
        form.set("int1","1");
        form.set("string1","2");
        form.set("subSqlDate1","12/03/2004");
        form.set("sex1","M");
        
        ActionMapping mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        mapping.setName(formName);
        
        Object object = formUtils.getFormValuesImpl(
                form, action, mapping, request);

        assertNotNull("Null object returned", object);
        assertTrue("Invalid object type returned", 
                object instanceof MultiSampleBeanA);
        
        MultiSampleBeanA bean = (MultiSampleBeanA) object;
        
        // check the values of the bean
        assertEquals("Incorrect bean value", 1, bean.getInt1());
        assertEquals("Incorrect bean value", "2", bean.getString1());
        assertNull("Incorrect bean value", bean.getSex1());
        assertNull("Incorrect bean value", bean.getSubSqlDate1());
    }

    /**
     * See if the expected exception is thrown when formatting dates
     * without specifying a date format.
     */
    public void testGetFormValuesNoDateFormat()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        String formName = "multiSampleBeanA2";
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm(formName,
                        action, mapping, request);
        
        form.set("int1","1");
        form.set("string1","2");
        form.set("subSqlDate1","12/03/2004");
        form.set("sex1","M");
        
        ActionMapping mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        mapping.setName(formName);
        
        try {
            formUtils.getFormValuesImpl(form, action, mapping, request);
            assertTrue("Expected an exception when formatting a date without a specified format", false);
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * Test the setting of fields that use accessor methods that do not follow
     * JavaBean conventions.
     */
    public void testGetFormValuesUnconventionalAccessors()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        String formName = "multiSampleBeanA3";
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm(formName,
                        action, mapping, request);
        
        form.set("int1","1");
        form.set("string1","2");
        form.set("sex1","M");
        form.set("double1","3.0");
        form.set("subSqlDate1","20041203");
        
        ActionMapping mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        mapping.setName(formName);
        
        Object object = formUtils.getFormValuesImpl(
                form, action, mapping, request);

        assertNotNull("Null object returned", object);
        assertTrue("Invalid object type returned", 
                object instanceof MultiSampleBeanA);
        
        MultiSampleBeanA bean = (MultiSampleBeanA) object;
        
        // check the values of the bean
        assertEquals("Incorrect bean value", 1, bean.getInt1());
        assertEquals("Incorrect bean value", "2", bean.getString1());
        assertEquals("Incorrect bean value", 3, bean.getDouble1Value(), 0);
        assertNull("Incorrect bean value", bean.getSex1());
        assertEquals("Incorrect bean value",
                "12/03/2004",
                new SimpleDateFormat("MM/dd/yyyy").format(bean.getSubSqlDate1()));
    }

    /**
     * Test the setting of fields that use custom converters.
     */
    public void testGetFormValuesCustomConverter()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        String formName = "multiSampleBeanA4";
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm(formName,
                        action, mapping, request);
        
        form.set("int1","1");
        form.set("string1","2");
        form.set("subSqlDate1","12/03/2004");
        form.set("sex1","M");
        
        ActionMapping mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        mapping.setName(formName);
        
        Object object = formUtils.getFormValuesImpl(
                form, action, mapping, request);

        assertNotNull("Null object returned", object);
        assertTrue("Invalid object type returned", 
                object instanceof MultiSampleBeanA);
        
        MultiSampleBeanA bean = (MultiSampleBeanA) object;
        
        // check the values of the bean
        assertEquals("Incorrect bean value", 1, bean.getInt1());
        assertEquals("Incorrect bean value", "2", bean.getString1());
        assertEquals("Incorrect bean value", Sex.MALE, bean.getSex1());
        assertNull("Incorrect bean value", bean.getSubSqlDate1());
    }

    /**
     * Expect an error to be thrown when we can't find the form def.
     */
    public void testGetFormValuesNoFormDefinition()
            throws Exception {

        FormUtils formUtils = new FormUtils();
        String formName = "multiSampleBeanA1";
        DynaActionForm form = (DynaActionForm)
                formUtils.createActionForm(formName,
                        action, mapping, request);
        
        form.set("int1","1");
        form.set("string1","2");
        form.set("subSqlDate1","12/03/2004");
        form.set("sex1","M");
        
        ActionMapping mapping = new ActionMapping();
        mapping.setModuleConfig(moduleConfig);
        mapping.setName("nonExistingForm");
        
        try {
            formUtils.getFormValuesImpl(form, action, mapping, request);
            assertTrue("Found non-existing form", false);
        } catch (IllegalArgumentException e) {
        }
    }

    //  end of testGetFormValuesXYZ methods
    // **********************************

}
