package formdef.plugin.util;

import formdef.plugin.config.FormDefConfig;
import formdef.plugin.config.FormMappingConfig;
import formdef.plugin.config.GlobalConverterConfig;
import formdef.plugin.digester.DefaultDigester;
import formdef.plugin.mock.MockActionServlet;
import formdef.plugin.sample.SampleBean2;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.struts.Globals;
import org.apache.struts.action.Action;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.mock.MockAction;
import org.apache.struts.mock.MockHttpServletRequest;
import org.apache.struts.mock.MockHttpSession;
import org.apache.struts.mock.MockServletContext;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Locale;

public class TestPropertyResourceLocaleUtil 
        extends TestCase {
    
    

    //*****************************
    // the usual suspects

    public TestPropertyResourceLocaleUtil(String s) {
        super(s);
    }

    public static TestSuite getSuite() {
        return new TestSuite(TestFormUtilsPopulateFormLocale.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner runner = new junit.textui.TestRunner();
        runner.doRun(TestFormUtilsPopulateFormLocale.getSuite());
    }



    //*****************************

    protected GlobalConverterConfig mdyConverter = null;

    SampleBean2 sampleBean2a = null;
    protected FormMappingConfig sampleBean2aFormConfig = null;
    protected FormMappingConfig sampleBean2bFormConfig = null;
   
    protected FormDefConfig testConfig = null;
    
    /** mock servlet objects */
    protected MockServletContext servletContext = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpSession session = null;

    protected Locale locale = null;
    
    /** empty module config */
    protected ModuleConfig moduleConfig = null;

    protected Action action = null;
    MockActionServlet actionServlet = null;

    PropertyResourceLocaleUtil util = null;    
    
    
    public void setUp()
            throws Exception {
        super.setUp();

        String filename = "formdef/plugin/util/form-utils-populate-form-locale.xml";
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream(filename);
        testConfig = new FormDefConfig();
        DefaultDigester.readConfiguration(testConfig, new BufferedInputStream(is));
        is.close();

        // prepare a module config
        moduleConfig = 
                ModuleConfigFactory.createFactory().createModuleConfig("");
        moduleConfig.setPrefix("");

        testConfig.registerForms(moduleConfig);

        // prepare the mock servlet objects
        servletContext = new MockServletContext();
        session = new MockHttpSession(servletContext);
        locale = Locale.getDefault();
        request = new MockHttpServletRequest(session);
        request.setLocale(locale);
        
        // store our config objects in the servlet context
        servletContext.setAttribute(
                FormDefConfig.FORMDEF_KEY + moduleConfig.getPrefix(),
                testConfig);
        servletContext.setAttribute(Globals.MODULE_KEY, moduleConfig);
        
        action = new MockAction();
        actionServlet = new MockActionServlet();
        actionServlet.setServletContext(servletContext);
        action.setServlet(actionServlet);


        //// Instantiate the controller configuration for this app
        //ControllerConfig controller = new ControllerConfig();
        //moduleConfig.setControllerConfig(controller);

        // Configure two resource bundles
        String configParameter 
                = "formdef.plugin.util.TestPropertyResourceLocaleUtil";
        
        MessageResourcesConfig messageResourcesConfig =
                new MessageResourcesConfig();
        messageResourcesConfig.setParameter
                (configParameter);
        moduleConfig.addMessageResourcesConfig(messageResourcesConfig);

        // Initialize the resource bundles
        try {
            actionServlet.initModuleMessageResources(moduleConfig);
        } catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Exception(
                    "Exception in TestActionRedirect.setupModuleConfig4(): "
                    + e.getMessage());
        }
                
        util = new PropertyResourceLocaleUtil(
                servletContext, moduleConfig, configParameter);
    }

    
    public void testLookupWithNull()
            throws Exception {
        
        Locale actual = util.getLocale(null, "format.date");
        
        assertEquals("Incorrect locale result.", "", actual.toString());
    }

    
    public void testRepeatLookups()
            throws Exception {
        
        Locale actual = util.getLocale(null, "format.date");
        
        assertEquals("Incorrect locale result.", "", actual.toString());
        
        // a repeat should produce the same result
        //  (and make sure an early bug doesn't reexpose itself)
        actual = util.getLocale(null, "format.date");
        assertEquals("Incorrect locale result.", "", actual.toString());
    }

    
    public void testLookupWithUnknownKey()
            throws Exception {
        
        Locale actual = util.getLocale(null, "unknown.key");        

        assertNull("Should've gotten null", actual);
    }


    public void testLookupExistingLocale()
            throws Exception {
        
        Locale actual = util.getLocale(new Locale("de"), "format.date");
       
        assertEquals("Incorrect locale result.", "de", actual.toString());
    }


    public void testLookupWithUnknownLocale1()
            throws Exception {
        
        Locale locale = new Locale("en");
        Locale actual = util.getLocale(locale, "format.date");
        
        assertEquals("Incorrect locale result.",
                Locale.getDefault().toString(), actual.toString());

        // "en.format.date" should now be present in the localeResults
        assertNotNull("Missing cache in localeResults",
                util.localeResults.get("en.format.date"));

        // repeat the lookup; should get the same result
        actual = util.getLocale(locale, "format.date");
        assertEquals("Incorrect locale result.",
                Locale.getDefault().toString(), actual.toString());
    }

    
    public void testLookupWithUnknownLocale2()
            throws Exception {
        
        Locale locale = new Locale("fr");
        Locale actual = util.getLocale(locale, "format.date");
        
        assertEquals("Incorrect locale result.",
                Locale.getDefault().toString(), actual.toString());

        // "fr.format.date" should now be present in the localeResults
        assertNotNull("Missing cache in localeResults",
                util.localeResults.get("fr.format.date"));

        // look it up again; should get the same thing
        actual = util.getLocale(locale, "format.date");        
        assertEquals("Incorrect locale result.",
                Locale.getDefault().toString(), actual.toString());
    }
    

    public void testLookupWithDefaultLocale()
            throws Exception {
        
        Locale locale = Locale.getDefault();
        Locale actual = util.getLocale(locale, "format.date");
        
        assertEquals("Incorrect locale result.",
                Locale.getDefault().toString(), actual.toString());

        // "en.format.date" should now be present in the localeResults
        assertNotNull("Missing cache in localeResults",
                util.localeResults.get(Locale.getDefault().toString() + ".format.date"));

        // repeat the lookup; should get the same result
        actual = util.getLocale(locale, "format.date");
        assertEquals("Incorrect locale result.",
                Locale.getDefault().toString(), actual.toString());
    }


    /**
     * Test looking up a locale that's represented by its own properties file,
     * but whose key was not specified in that file.
     */ 
    public void testLookupExistingLocaleButNoLocaleSpecificValue()
            throws Exception {
        
        Locale actual = util.getLocale(new Locale("it"), "format.date");
        
        assertEquals("Unspecified format should use default locale.",
                Locale.getDefault().toString(), actual.toString());
    }

    
    /**
     * Test looking up a locale that's represented by its own properties file,
     * but whose key is not specified anywhere.
     */ 
    public void testLookupExistingLocaleButUnknownKey()
            throws Exception {
        
        Locale actual = util.getLocale(new Locale("it"), "unknown.key");
        
        assertNull("Unspecified key should result in a null.", actual);
    }


    private void showUtilCacheContents(PropertyResourceLocaleUtil util) {
        java.util.Iterator iterator = util.localeResults.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object o = util.localeResults.get(key);
            System.out.println("localeResults(" + key + ")=[" + o + "]");
        }
        System.out.println("");
    }
}
