/*
 * Decompiled with CFR 0.152.
 */
package formdef.plugin.util;

import formdef.plugin.FormMapping;
import formdef.plugin.PropertyMapping;
import formdef.plugin.config.FormDefConfig;
import formdef.plugin.conversion.ConversionContext;
import formdef.plugin.conversion.Converter;
import formdef.plugin.conversion.FormCollectionConverter;
import formdef.plugin.conversion.FormConverter;
import formdef.plugin.util.FormUtilsFactory;
import formdef.plugin.util.ResourceLocaleUtil;
import formdef.plugin.util.ResourceLocaleUtilFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;

public class FormUtils {
    private static final Log log = LogFactory.getLog((Class)(class$formdef$plugin$util$FormUtils == null ? (class$formdef$plugin$util$FormUtils = FormUtils.class$("formdef.plugin.util.FormUtils")) : class$formdef$plugin$util$FormUtils));
    protected static FormUtils instance = null;
    protected static String factoryClassName = "formdef.plugin.util.FormUtilsFactoryImpl";
    protected static String resourceLocaleUtilFactoryClassName = "formdef.plugin.util.ResourceLocaleUtilFactoryImpl";
    protected Map formNames = new HashMap();
    static /* synthetic */ Class class$formdef$plugin$util$FormUtils;

    public static ActionForm setFormValues(String formName, Object source, Action action, ActionMapping mapping, HttpServletRequest request) {
        return FormUtils.getInstance().setFormValuesImpl(formName, source, action, mapping, request);
    }

    public static Object getFormValues(ActionForm actionForm, Action action, ActionMapping mapping, HttpServletRequest request) {
        return FormUtils.getInstance().getFormValuesImpl(actionForm, action, mapping, request);
    }

    public static Object getFormValues(ActionForm actionForm, String formName, Action action, ActionMapping mapping, HttpServletRequest request) {
        return FormUtils.getInstance().getFormValuesImpl(actionForm, formName, action, mapping, request);
    }

    public static void getFormValues(ActionForm actionForm, Object dest, Action action, ActionMapping mapping, HttpServletRequest request) {
        FormUtils.getInstance().getFormValuesImpl(actionForm, dest, action, mapping, request);
    }

    public static void getFormValues(ActionForm actionForm, Object dest, String formName, Action action, ActionMapping mapping, HttpServletRequest request) {
        FormUtils.getInstance().getFormValuesImpl(actionForm, dest, formName, action, mapping, request);
    }

    public static String lookupFormName(Object object, Action action, ActionMapping mapping) {
        return FormUtils.getInstance().lookupFormNameImpl(object, action, mapping);
    }

    public static FormUtils getInstance() {
        if (instance == null) {
            FormUtilsFactory factory = FormUtils.getFormUtilsFactory();
            instance = factory.createFormUtils();
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting FormUtils instance to " + instance));
            }
        }
        return instance;
    }

    public static void setFactoryClassName(String factoryClassName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting factoryClassName to " + factoryClassName));
        }
        FormUtils.factoryClassName = factoryClassName;
    }

    public static void setResourceLocaleUtilFactoryClassName(String resourceLocaleUtilFactoryClassName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting resourceLocaleUtilFactoryClassName to " + resourceLocaleUtilFactoryClassName));
        }
        FormUtils.resourceLocaleUtilFactoryClassName = resourceLocaleUtilFactoryClassName;
    }

    protected static FormUtilsFactory getFormUtilsFactory() {
        FormUtilsFactory factory = null;
        try {
            factory = (FormUtilsFactory)RequestUtils.applicationInstance((String)factoryClassName);
        }
        catch (Exception e) {
            log.error((Object)("Exception [" + e + "," + e.getMessage() + "]"), (Throwable)e);
            String message = "Unable to create FormUtilsFactory object: " + factoryClassName;
            throw new IllegalArgumentException(message);
        }
        return factory;
    }

    protected ResourceLocaleUtilFactory getResourceLocaleUtilFactory() {
        ResourceLocaleUtilFactory factory = null;
        try {
            factory = (ResourceLocaleUtilFactory)RequestUtils.applicationInstance((String)resourceLocaleUtilFactoryClassName);
        }
        catch (Exception e) {
            log.error((Object)("Exception [" + e + "," + e.getMessage() + "]"), (Throwable)e);
            String message = "Unable to create ResourceLocaleUtilFactory object: " + resourceLocaleUtilFactoryClassName;
            throw new IllegalArgumentException(message);
        }
        return factory;
    }

    public FormDefConfig getFormDefConfig(ServletContext context, ModuleConfig moduleConfig) {
        FormDefConfig config = (FormDefConfig)context.getAttribute("formdef.plugin.FormDefPlugIn" + moduleConfig.getPrefix());
        return config;
    }

    public FormMapping findFormDefinition(String formName, ServletContext context, ModuleConfig moduleConfig) {
        FormDefConfig config = this.getFormDefConfig(context, moduleConfig);
        FormMapping form = config.getForm(formName);
        return form;
    }

    public ActionForm setFormValuesImpl(String formName, Object source, Action action, ActionMapping mapping, HttpServletRequest request) {
        ModuleConfig moduleConfig = mapping.getModuleConfig();
        ActionForm form = this.createActionForm(formName, action, mapping, request);
        if (form instanceof DynaBean) {
            this.populateForm(formName, form, source, moduleConfig, action, mapping, request);
        }
        return form;
    }

    public void populateForm(String formName, DynaActionForm dynaForm, Object source, Action action, ModuleConfig moduleConfig, HttpServletRequest request) {
        this.populateForm(formName, (ActionForm)dynaForm, source, moduleConfig, action, null, request);
    }

    public void populateForm(String formName, ActionForm actionForm, Object source, ModuleConfig moduleConfig, Action action, ActionMapping mapping, HttpServletRequest request) {
        ServletContext context = action.getServlet().getServletContext();
        FormMapping formMapping = this.findFormDefinition(formName, context, moduleConfig);
        if (formMapping == null) {
            throw new IllegalArgumentException("Unable to find the definition for " + formName);
        }
        DynaClass dynaClass = null;
        if (!(actionForm instanceof DynaBean)) {
            throw new IllegalArgumentException(formName + " is not a DynaBean implementation");
        }
        dynaClass = ((DynaBean)actionForm).getDynaClass();
        Map properties = formMapping.getProperties();
        Iterator iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            PropertyMapping property = (PropertyMapping)properties.get(propertyName);
            Converter converter = (Converter)property.getConverter();
            if (converter == null) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Skipping conversion of " + property.getName() + " due to a null converter"));
                continue;
            }
            if (property.getGetter() == null) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Skipping conversion of " + property.getName() + " due to a null getter"));
                continue;
            }
            Object value = null;
            try {
                value = property.getGetter().invoke(source, new Object[0]);
                DynaProperty dynaProperty = dynaClass.getDynaProperty(propertyName);
                Class formType = dynaProperty.getType();
                ConversionContext conversionContext = this.prepareConversionContext(source, actionForm, propertyName, value, formType, property, action, mapping, request);
                Object formattedValue = converter.convert(conversionContext);
                PropertyUtils.setProperty((Object)actionForm, (String)propertyName, (Object)formattedValue);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)(e + " was thrown during converion of " + propertyName), (Throwable)e);
                }
                throw new IllegalArgumentException();
            }
        }
    }

    protected ConversionContext prepareConversionContext(Object value, Class type, HttpServletRequest request, PropertyMapping property, Action action) {
        ConversionContext conversionContext = new ConversionContext(value, type);
        conversionContext.setLocale(this.getLocale(request));
        this.populateConversionParameter(conversionContext, property, request, action);
        return conversionContext;
    }

    protected ConversionContext prepareConversionContext(Object source, Object destination, String propertyName, Object value, Class type, PropertyMapping property, Action action, ActionMapping mapping, HttpServletRequest request) {
        ConversionContext conversionContext = new ConversionContext(value, type);
        conversionContext.setSource(source);
        conversionContext.setDestination(destination);
        conversionContext.setPropertyName(propertyName);
        conversionContext.setLocale(this.getLocale(request));
        conversionContext.setAction(action);
        conversionContext.setMapping(mapping);
        conversionContext.setRequest(request);
        conversionContext.setProperties(property.getProperties());
        this.populateConversionParameter(conversionContext, property, request, action);
        return conversionContext;
    }

    public DynaActionForm createDynaActionForm(String formName, ModuleConfig moduleConfig, Action action) {
        DynaActionForm dynaForm = null;
        try {
            FormBeanConfig formBeanConfig = moduleConfig.findFormBeanConfig(formName);
            dynaForm = (DynaActionForm)formBeanConfig.createActionForm(action.getServlet());
        }
        catch (Exception e) {
            String message = "Unable to create the form bean for " + formName;
            log.error((Object)(message + " [" + e + "," + e.getMessage() + "]"), (Throwable)e);
            throw new RuntimeException(message);
        }
        return dynaForm;
    }

    public ActionForm createActionForm(String formName, Action action, ActionMapping mapping, HttpServletRequest request) {
        ActionForm form = null;
        try {
            ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request);
            FormBeanConfig formBeanConfig = moduleConfig.findFormBeanConfig(formName);
            form = formBeanConfig.createActionForm(action.getServlet());
            FormMapping formMapping = this.findFormDefinition(formName, action.getServlet().getServletContext(), moduleConfig);
            if (formMapping != null) {
                this.initializeNestedForms(form, formMapping, action, mapping, request);
            }
        }
        catch (Exception e) {
            String message = "Unable to create the form bean for " + formName;
            log.error((Object)(message + " [" + e + "," + e.getMessage() + "]"), (Throwable)e);
            throw new RuntimeException(message);
        }
        return form;
    }

    protected void initializeNestedForms(ActionForm form, FormMapping formMapping, Action action, ActionMapping mapping, HttpServletRequest request) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Map properties = formMapping.getProperties();
        Iterator iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            PropertyMapping property = (PropertyMapping)properties.get(iterator.next());
            Object converter = property.getConverter();
            if (converter instanceof FormConverter) {
                String name = property.getConversionParam();
                if (name == null) continue;
                ActionForm value = this.createActionForm(name, action, mapping, request);
                PropertyUtils.setProperty((Object)form, (String)property.getName(), (Object)value);
                continue;
            }
            if (!(converter instanceof FormCollectionConverter)) continue;
            FormCollectionConverter fcc = (FormCollectionConverter)converter;
            ConversionContext context = this.prepareConversionContext(null, form, property.getName(), null, property.getFormFieldType(), property, action, mapping, request);
            context.setProperty("formdef.plugin.conversion.FormCollectionConverter.initializeForm", new Boolean(true).toString());
            Collection value = fcc.getFormCollection(context, property.getName(), null);
            PropertyUtils.setProperty((Object)form, (String)property.getName(), (Object)value);
        }
    }

    public Object getFormValuesImpl(ActionForm actionForm, Action action, ActionMapping mapping, HttpServletRequest request) {
        String formName = mapping.getName();
        return this.getFormValuesImpl(actionForm, formName, action, mapping, request);
    }

    public void getFormValuesImpl(ActionForm actionForm, Object dest, Action action, ActionMapping mapping, HttpServletRequest request) {
        String formName = mapping.getName();
        this.getFormValuesImpl(actionForm, dest, formName, action, mapping, request);
    }

    public Object getFormValuesImpl(ActionForm actionForm, String formName, Action action, ActionMapping mapping, HttpServletRequest request) {
        ModuleConfig moduleConfig;
        ServletContext context = action.getServlet().getServletContext();
        FormMapping formMapping = this.findFormDefinition(formName, context, moduleConfig = mapping.getModuleConfig());
        if (formMapping == null) {
            throw new IllegalArgumentException("Unable to find the definition for " + formName);
        }
        Object populatedObject = this.createObjectInstance(formMapping);
        this.getFormValuesImpl(actionForm, populatedObject, formName, action, mapping, request);
        return populatedObject;
    }

    public void getFormValuesImpl(ActionForm actionForm, Object dest, String formName, Action action, ActionMapping mapping, HttpServletRequest request) {
        ModuleConfig moduleConfig;
        if (!(actionForm instanceof DynaBean)) {
            throw new IllegalArgumentException(formName + " is not a DynaBean implementation.");
        }
        ServletContext context = action.getServlet().getServletContext();
        FormMapping formMapping = this.findFormDefinition(formName, context, moduleConfig = mapping.getModuleConfig());
        if (formMapping == null) {
            throw new IllegalArgumentException("Unable to find the definition for " + formName);
        }
        Class beanType = formMapping.getBeanType();
        if (!beanType.isInstance(dest)) {
            throw new IllegalArgumentException("The given destination object is not an instance of " + beanType.getName());
        }
        this.populateBeanFromForm(formMapping, dest, actionForm, action, mapping, request);
    }

    public Object createObjectInstance(FormMapping form) {
        if (form == null) {
            throw new IllegalArgumentException("form param cannot be null.");
        }
        Object populatedObject = null;
        if (form.getFactoryMethod() != null) {
            Object[] params = null;
            params = form.isFactoryMethodNameParam() ? new Object[]{form.getName()} : new Object[]{};
            try {
                populatedObject = form.getFactoryMethod().invoke(form.getFactory(), params);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)(e + " was thrown while calling bean factory " + " for " + form.getName()), (Throwable)e);
                throw new IllegalArgumentException();
            }
        }
        try {
            Constructor constructor = form.getBeanType().getConstructor(new Class[0]);
            populatedObject = constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"Cannot find no-arg constructor", (Throwable)e);
            throw new IllegalArgumentException("Cannot find no-arg constructor for " + form.getName());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("Exception creating object instance for " + form.getName()), (Throwable)e);
            throw new IllegalArgumentException("Unable to instantiate " + form.getName());
        }
        return populatedObject;
    }

    public void populateBeanFromForm(FormMapping form, Object dest, ActionForm src, HttpServletRequest request, Action action) throws IllegalAccessException, InvocationTargetException {
        this.populateBeanFromForm(form, dest, src, action, null, request);
    }

    public void populateBeanFromForm(FormMapping form, Object dest, ActionForm src, Action action, ActionMapping mapping, HttpServletRequest request) {
        Map properties = form.getProperties();
        Iterator iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            PropertyMapping property = (PropertyMapping)properties.get(propertyName);
            Converter converter = (Converter)property.getConverter();
            if (converter == null) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Skipping conversion of " + property.getName() + " due to a null converter"));
                continue;
            }
            if (property.getSetter() == null) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Skipping conversion of " + property.getName() + " due to a null setter"));
                continue;
            }
            Object formattedValue = null;
            try {
                formattedValue = PropertyUtils.getProperty((Object)src, (String)propertyName);
                ConversionContext conversionContext = this.prepareConversionContext(src, dest, propertyName, formattedValue, property.getType(), property, action, mapping, request);
                Object value = converter.convert(conversionContext);
                property.getSetter().invoke(dest, value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)("Unable to populate the bean for " + form.getName()), (Throwable)e);
                throw new IllegalArgumentException("Unable to populate the bean for " + form.getName());
            }
        }
    }

    public Class classForName(String className) throws ClassNotFoundException {
        Class<?> result = null;
        ClassNotFoundException caught = null;
        try {
            result = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            caught = e;
        }
        if (result == null) {
            if (className.equals(Boolean.TYPE.getName())) {
                return Boolean.TYPE;
            }
            if (className.equals(Byte.TYPE.getName())) {
                return Byte.TYPE;
            }
            if (className.equals(Character.TYPE.getName())) {
                return Character.TYPE;
            }
            if (className.equals(Double.TYPE.getName())) {
                return Double.TYPE;
            }
            if (className.equals(Float.TYPE.getName())) {
                return Float.TYPE;
            }
            if (className.equals(Integer.TYPE.getName())) {
                return Integer.TYPE;
            }
            if (className.equals(Long.TYPE.getName())) {
                return Long.TYPE;
            }
            if (className.equals(Short.TYPE.getName())) {
                return Short.TYPE;
            }
            if (caught != null) {
                throw caught;
            }
            throw new ClassNotFoundException("Unable to find class " + className);
        }
        return result;
    }

    protected void populateConversionParameter(ConversionContext conversionContext, PropertyMapping property, HttpServletRequest request, Action action) {
        String conversionParameter = property.getConversionParam();
        if (conversionParameter == null || conversionParameter.length() == 0) {
            String key = property.getConversionKey();
            String bundle = property.getConversionBundle();
            if (key != null && key.length() > 0) {
                if (bundle != null && bundle.length() == 0) {
                    bundle = null;
                }
                ServletContext servletContext = action.getServlet().getServletContext();
                conversionParameter = this.evaluateMessage(key, bundle, request, servletContext);
                ResourceLocaleUtil resourceLocaleUtil = this.getResourceLocaleUtilFactory().getLocaleUtil(request, servletContext, bundle);
                Locale actualLocale = resourceLocaleUtil.getLocale(conversionContext.getLocale(), key);
                conversionContext.setLocale(actualLocale);
            }
        }
        conversionContext.setParam(conversionParameter);
    }

    protected Locale getLocale(HttpServletRequest request) {
        Locale locale = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        return locale;
    }

    protected String evaluateMessage(String messageKey, String bundle, HttpServletRequest request, ServletContext servletContext) {
        MessageResources resources = bundle != null ? this.getResources(bundle, request, servletContext) : this.getResources(request);
        String messageString = this.getMessage(messageKey, null, request, resources);
        if (messageString != null && messageString.length() > 0) {
            return messageString;
        }
        return null;
    }

    protected String getMessage(String messageKey, Object[] args, HttpServletRequest request, MessageResources resources) {
        String result;
        block4: {
            if (messageKey == null) {
                return null;
            }
            result = null;
            try {
                Locale userLocale = this.getLocale(request);
                if (args == null) {
                    result = resources.getMessage(userLocale, messageKey);
                    break block4;
                }
                result = resources.getMessage(userLocale, messageKey, args);
            }
            catch (Exception e) {}
        }
        return result;
    }

    protected MessageResources getResources(HttpServletRequest request) {
        return (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
    }

    protected MessageResources getResources(String bundle, HttpServletRequest request, ServletContext servletContext) {
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request, servletContext);
        return (MessageResources)servletContext.getAttribute(bundle + moduleConfig.getPrefix());
    }

    public String lookupFormNameImpl(Object object, Action action, ActionMapping mapping) {
        String formName = null;
        ModuleConfig moduleConfig = mapping.getModuleConfig();
        String objectName = object.getClass().getName();
        String key = moduleConfig.getPrefix() + objectName;
        if (this.formNames.containsKey(key)) {
            return (String)this.formNames.get(key);
        }
        ServletContext servletContext = action.getServlet().getServletContext();
        FormDefConfig config = this.getFormDefConfig(servletContext, moduleConfig);
        int i = 0;
        while (i < config.getFormNames().length) {
            FormMapping formMapping = config.getForm(config.getFormNames()[i]);
            if (formMapping.getBeanType().getName().equals(objectName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found mapping for: " + objectName + " it is: " + formMapping.getName()));
                }
                formName = formMapping.getName();
                break;
            }
            ++i;
        }
        if (formName != null) {
            this.formNames.put(key, formName);
        }
        return formName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

